/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logviewer.webview;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import ro.amiq.dvt.logviewer.LogViewerEditor;
import ro.amiq.dvt.logviewer.webview.ILogViewerWebview;

public enum LogViewerWebviewManager {
    INSTANCE;

    private final Map<String, ILogViewerWebview> webviews = new HashMap<String, ILogViewerWebview>();

    public ILogViewerWebview getWebview(String filePath) {
        if (filePath == null) {
            return null;
        }
        return this.webviews.get(filePath);
    }

    protected void registerWebView(String filePath, ILogViewerWebview webview) {
        if (filePath == null || webview == null) {
            return;
        }
        this.webviews.put(filePath, webview);
    }

    public void clearWebview(String filePath) {
        if (filePath == null) {
            return;
        }
        if (!this.webviews.containsKey(filePath)) {
            return;
        }
        this.webviews.remove(filePath);
    }

    public LogViewerEditor findLogViewerEditor(IWorkbenchPage page, String logFilePath) {
        IEditorReference[] editorReferences;
        if (logFilePath == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            LogViewerEditor editor;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart instanceof LogViewerEditor && Objects.equals(logFilePath, (editor = (LogViewerEditor)editorPart).getLogFilePath())) {
                return editor;
            }
            ++n2;
        }
        return null;
    }
}

