/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.core;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import ro.amiq.dvt.DVTActivator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.actions.DVTActionManager;
import ro.amiq.dvt.ui.actions.IMacroTraceListener;
import ro.amiq.dvt.ui.actions.MacroTraceActionManager;
import ro.amiq.edt.base.builders.EMacroTraceConsoleViewer;
import ro.amiq.edt.base.core.EDTBaseActivator;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.core.EDTPluginCommon;
import ro.amiq.edt.externaltools.EExternalToolsDelegate;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.ui.encrypted.EncryptedLabelManager;
import ro.amiq.edt.ui.launch.SpecmanLaunchShortcut;
import ro.amiq.edt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.edt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.edt.ui.syntaxerrors.SyntaxErrorsManager;
import ro.amiq.etools.eparser.EParser;

public class EDTPlugin
extends EDTPluginCommon {
    private static EDTPlugin fPlugin;
    private IPreferenceStore fCombinedPreferenceStore;

    public EDTPlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DVTLogger.INSTANCE.logDebug(">> Started EDT Plugin (version: " + (String)this.getBundle().getHeaders().get("Bundle-Version") + ").");
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2 && event.getBundle().getSymbolicName().equals("ro.amiq.edt")) {
                    DVTLogger.INSTANCE.logDebug(">> Started EDT initialization.");
                    new DVTActivator();
                    new EDTBaseActivator();
                    SyntaxErrorsManager.getInstance().startup();
                    EncryptedLabelManager.getInstance().startup();
                    MacroTraceActionManager.getInstance().addMacroTraceListener("ro.amiq.edt", (IMacroTraceListener)new EMacroTraceConsoleViewer((AbstractRfManager)RfManager.getInstance()));
                    ExternalToolsModelManager.getInstance().addExternalToolsDelegate((IExternalToolsDelegate)EExternalToolsDelegate.getInstance());
                    DVTLogger.INSTANCE.logDebug("Using " + EParser.getVersion());
                    try {
                        while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DVTLogger.INSTANCE.logDebug(">> Started EDT UI initialization.");
                            EDTPlugin.getDefault().getPreferenceStore().setDefault("ro.amiq.edt.VRST_HOME", "");
                            DVTActionManager.setActionDelegate((String)"ro.amiq.dvt.ui.launch.SpecmanLaunchShortcut", (IObjectActionDelegate)new SpecmanLaunchShortcut());
                            DVTMixedLangModelManager.getInstance().registerModelManager((DVTModelManager)EModelManager.getInstance());
                            PersistentTaskManager.getInstance().startup();
                            NameCheckerWarningsManager.getInstance();
                            ObjectionManager.getInstance().clear(Objection.EDT_INITIALIZED);
                            DVTLogger.INSTANCE.logDebug("<< Ended EDT UI initialization.");
                        }
                    });
                    DVTLogger.INSTANCE.logDebug("<< Ended EDT initialization.");
                }
            }
        });
    }

    @Override
    public void stop(BundleContext context) {
        try {
            super.stop(context);
            EncryptedLabelManager.getInstance().shutdown();
            PersistentTaskManager.getInstance().shutdown();
            MacroTraceActionManager.getInstance().removeMacroTraceListener("ro.amiq.edt");
            DVTPlugin.getDefault().collect().i("F65");
            DVTLogger.INSTANCE.logDebug("<< Ended EDT Plugin.");
        }
        finally {
            fPlugin = null;
            super.stop(context);
        }
    }

    public static EDTPlugin getDefault() {
        return fPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ro.amiq.edt", (String)path);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public void savePreferences() {
        try {
            InstanceScope instance = new InstanceScope();
            instance.getNode("ro.amiq.edt").flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

