/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.launch;

import java.io.File;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ConsoleHighlightModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.core.EDTPlugin;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.ui.launch.console.SpecmanConsoleTracker;

public class SpecmanLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected static final String EMPTY_STRING = "";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", EMPTY_STRING);
        String testName = config.getAttribute("ro.amiq.edt.launch.TEST_ATTR", EMPTY_STRING);
        String workingDirectory = config.getAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", EMPTY_STRING);
        String specmanExecutable = config.getAttribute("ro.amiq.edt.launch.SPECMAN_EXECUTABLE_ATTR", "specman");
        String testCommand = config.getAttribute("ro.amiq.edt.launch.COMMAND_ATTR", EMPTY_STRING);
        if (!(EMPTY_STRING.equals(projectName) || EMPTY_STRING.equals(testName) || EMPTY_STRING.equals(workingDirectory))) {
            CompilationUnitProperties compilationUnitProperties;
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F65")) {
                return;
            }
            IEProject eProject = EModelManager.getInstance().getEModel().getEProject(project);
            if (eProject == null) {
                return;
            }
            String command = EMPTY_STRING;
            IPreferenceStore preferenceStore = EDTPlugin.getDefault().getPreferenceStore();
            String vrstHome = preferenceStore.getString("ro.amiq.edt.VRST_HOME");
            if (vrstHome.length() > 0) {
                command = String.valueOf(command) + "export VRST_HOME=" + vrstHome + ";source $VRST_HOME/env.sh;";
            }
            if (!(compilationUnitProperties = eProject.getCompilationUnitProperties(false)).hasFilesToCompile()) {
                return;
            }
            String rawSpecmanPath = compilationUnitProperties.getSpecmanPath();
            if (rawSpecmanPath != null && rawSpecmanPath.length() != 0) {
                command = String.valueOf(command) + "export SPECMAN_PATH=" + rawSpecmanPath + ";";
            }
            command = String.valueOf(command) + "echo [Info] \\$LM_LICENSE_FILE= $LM_LICENSE_FILE;";
            command = String.valueOf(command) + "echo [Info] \\$VRST_HOME= $VRST_HOME;";
            command = String.valueOf(command) + "echo [Info] \\$SPECMAN_PATH= $SPECMAN_PATH;";
            command = String.valueOf(command) + "echo [Info] 'Launching: " + specmanExecutable + " with test file " + testName + " ...';echo;";
            command = String.valueOf(command) + specmanExecutable + " -c 'loa " + testName + ";" + testCommand + "';";
            Process p = DebugPlugin.exec((String[])new String[]{"sh", "-c", command = String.valueOf(command) + "echo;echo [Info] Launch completed.;"}, (File)new File(workingDirectory));
            IProcess iProc = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"Load in Specman Process");
            IConsole console = DVTJobsUtils.waitForConsole((IProcess)iProc, (IProgressMonitor)monitor);
            if (console != null) {
                this.setListeners(project, (IOConsole)console);
            }
        }
    }

    private void setListeners(IProject project, IOConsole ioConsole) {
        SpecmanConsoleTracker tracker = new SpecmanConsoleTracker();
        ioConsole.addPatternMatchListener((IPatternMatchListener)tracker);
        ConsoleHighlightModelManager.getInstance().fConsoleToListeners.putIfAbsent(ioConsole, new ConcurrentLinkedQueue());
        Queue listeners = (Queue)ConsoleHighlightModelManager.getInstance().fConsoleToListeners.get(ioConsole);
        listeners.add(tracker);
        this.setProcessConsole(project, ioConsole);
    }

    private void setProcessConsole(IProject project, IOConsole ioConsole) {
        ExternalToolsConfiguration configExt = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)ioConsole, project, (IExternalToolsConfiguration)configExt, null, 1, project.getLocation().toOSString());
    }
}

