/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.linter.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.edt.linter.ruleset.RulesetKind;
import ro.amiq.edt.ovmcompliance.OVMComplianceManager;
import ro.amiq.edt.ui.wizards.OVMComplianceWizard;
import ro.amiq.edt.ui.wizards.actions.InterruptedBuildException;

public class ELintLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(configuration.getName()) + "...", 3);
        if (monitor.isCanceled()) {
            return;
        }
        String projectName = configuration.getAttribute("ro.amiq.dvt.linter.launch.project", "");
        IProject project = null;
        if (projectName == null || projectName.trim().length() == 0) {
            IResource resource = DebugUITools.getSelectedResource();
            if (resource == null) {
                this.abort("Project name is empty and no project is selected.", null, 150);
                return;
            }
            project = resource.getProject();
            projectName = project.getName();
        } else {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.trim());
        }
        if (project == null || !project.exists() || !project.isOpen()) {
            this.abort("Project '" + projectName + "' does not exist or is not opened.", null, 150);
            return;
        }
        String rulesetKindAttr = null;
        try {
            rulesetKindAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", "");
        }
        catch (CoreException e) {
            this.abort(e.getStatus().getMessage(), null, 150);
            return;
        }
        final RulesetKind rulesetKind = RulesetKind.from(rulesetKindAttr);
        if (rulesetKind == null) {
            this.abort("RulesetKind '" + rulesetKindAttr + "' is not valid.", null, 150);
            return;
        }
        final IProject finalProject = project;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int xvmMode;
                if (rulesetKind == RulesetKind.OVM_COMPLIANCE) {
                    xvmMode = 1;
                } else if (rulesetKind == RulesetKind.UVM_COMPLIANCE) {
                    xvmMode = 2;
                } else {
                    return;
                }
                boolean continueWithNewWizard = OVMComplianceManager.getInstance().run((IResource)finalProject, xvmMode);
                if (!continueWithNewWizard) {
                    return;
                }
                try {
                    OVMComplianceWizard wizard = new OVMComplianceWizard((IResource)finalProject, xvmMode);
                    wizard.init(PlatformUI.getWorkbench(), null);
                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
                    dialog.open();
                }
                catch (InterruptedBuildException interruptedBuildException) {}
            }
        });
    }

    private void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "ro.amiq.edt", code, message, exception));
    }
}

