/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.linter.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.edt.linter.ruleset.RulesetKind;

public class MainLintConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected Text fProjectField;
    protected Button fProjectButton;
    protected Combo fRulesetKindCombo;
    protected SelectionAdapter fSelectionAdapter;
    protected boolean fInitializing = false;
    private boolean fUserEdited = false;
    protected WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createProjectComponent(mainComposite);
        this.createRulesetComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createProjectComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = ExternalToolsMessages.ExternalToolsMainTab_Project_Simple;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fProjectField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fProjectField.setLayoutData((Object)data);
        this.fProjectField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fProjectField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fProjectButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab__Browse_Workspace____3, null);
        this.fProjectButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fProjectButton, String.valueOf(group.getText()) + " " + this.fProjectButton.getText());
    }

    protected void createRulesetComponent(Composite parent) {
        RulesetKind[] rulesetKinds;
        Group group = new Group(parent, 0);
        group.setText("Ruleset");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label rulesetKindText = new Label((Composite)group, 16384);
        rulesetKindText.setText("Kind:");
        gridData = new GridData(4, 0x1000000, false, false);
        rulesetKindText.setLayoutData((Object)gridData);
        this.fRulesetKindCombo = new Combo((Composite)group, 12);
        RulesetKind[] rulesetKindArray = rulesetKinds = RulesetKind.getAll();
        int n = rulesetKinds.length;
        int n2 = 0;
        while (n2 < n) {
            RulesetKind kind = rulesetKindArray[n2];
            this.fRulesetKindCombo.add(kind.toString());
            ++n2;
        }
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fRulesetKindCombo.setLayoutData((Object)gridData);
        this.fRulesetKindCombo.addModifyListener((ModifyListener)this.fListener);
        this.fRulesetKindCombo.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fRulesetKindCombo, group.getText());
    }

    private boolean isPredefinedRulesetKind() {
        String rulesetKind = this.fRulesetKindCombo.getText() == null ? "" : this.fRulesetKindCombo.getText();
        return RulesetKind.isPredefined(rulesetKind);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("ro.amiq.dvt.linter.launch.first-edit", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.updateProjectComponent(configuration);
        this.updateRulesetComponent(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    protected void updateProjectComponent(ILaunchConfiguration configuration) {
        String project = null;
        try {
            project = configuration.getAttribute("ro.amiq.dvt.linter.launch.project", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fProjectField.setText(project);
    }

    protected void updateRulesetComponent(ILaunchConfiguration configuration) {
        String rulesetKind = null;
        try {
            rulesetKind = configuration.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getPrefered().toString());
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fRulesetKindCombo.setText(rulesetKind);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String project = this.fProjectField.getText().trim();
        if (project.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.project", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.project", project);
        }
        String rulesetKind = this.fRulesetKindCombo.getText().trim();
        if (rulesetKind.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", rulesetKind);
        }
        if (this.fUserEdited) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.first-edit", null);
        }
    }

    public String getName() {
        return ExternalToolsMessages.ExternalToolsMainTab__Main_17;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean newConfig = false;
        try {
            newConfig = launchConfig.getAttribute("ro.amiq.dvt.linter.launch.first-edit", false);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.validateProject(newConfig) && this.validateRuleset(newConfig);
    }

    protected boolean validateProject(boolean newConfig) {
        String projectName = this.fProjectField.getText().trim();
        if (!projectName.isEmpty()) {
            Path projectPath = new Path(null, projectName);
            if (!projectPath.isValidSegment(projectName)) {
                this.setErrorMessage("Project name '" + projectName + "' not valid.");
                return false;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                this.setErrorMessage("Project '" + projectName + "' does not exist.");
                return false;
            }
        }
        return true;
    }

    protected boolean validateRuleset(boolean newConfig) {
        if (!this.isPredefinedRulesetKind()) {
            if (newConfig) {
                this.setErrorMessage(null);
                this.setMessage("Please specify the ruleset kind you would like to use.");
            } else {
                this.setErrorMessage("Ruleset kind is not valid.");
                this.setMessage(null);
            }
            return false;
        }
        return true;
    }

    protected void handleProjectButtonSelected() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project");
        dialog.setMessage("Select the project");
        ArrayList dvtProjects = Utils.getNatureMatchingProjects((String[])new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.dvt.dvtnature"});
        if (dvtProjects == null) {
            dialog.setElements((Object[])new IProject[0]);
        } else {
            dialog.setElements(dvtProjects.toArray());
        }
        if (dialog.open() == 0) {
            this.fProjectField.setText(((IProject)dialog.getFirstResult()).getName());
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    FocusListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!MainLintConfigurationTab.this.fInitializing) {
                MainLintConfigurationTab.this.setDirty(true);
                MainLintConfigurationTab.this.fUserEdited = true;
                MainLintConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            MainLintConfigurationTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == MainLintConfigurationTab.this.fProjectButton) {
                MainLintConfigurationTab.this.handleProjectButtonSelected();
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

