/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.linter.ruleset;

import ro.amiq.dvt.linter.ruleset.DVTRulesetKind;

public enum RulesetKind implements DVTRulesetKind
{
    OVM_COMPLIANCE("OVM Compliance", "ovm"),
    UVM_COMPLIANCE("UVM Compliance", "uvm");

    private final String fName;
    private final String fPrefix;

    private RulesetKind(String name, String prefix) {
        this.fName = name;
        this.fPrefix = prefix;
    }

    public static RulesetKind[] getAll() {
        return new RulesetKind[]{UVM_COMPLIANCE, OVM_COMPLIANCE};
    }

    public static RulesetKind getPreferedFor(String mode) {
        if (mode != null && mode.equalsIgnoreCase("uvm")) {
            return UVM_COMPLIANCE;
        }
        return OVM_COMPLIANCE;
    }

    public static RulesetKind getPrefered() {
        return RulesetKind.getPreferedFor("ovm");
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public String toString() {
        return this.fName;
    }

    public static RulesetKind from(String name) {
        if (name == null) {
            return null;
        }
        RulesetKind[] rulesetKindArray = RulesetKind.getAll();
        int n = rulesetKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulesetKind kind = rulesetKindArray[n2];
            if (kind.toString().equals(name.trim())) {
                return kind;
            }
            ++n2;
        }
        return null;
    }

    public boolean isPredefined() {
        return true;
    }

    public static boolean isPredefined(String kind) {
        RulesetKind rulesetKind = RulesetKind.from(kind);
        return rulesetKind != null;
    }
}

