/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.model.reflection.views;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.views.SequenceTreeWalker;
import ro.amiq.edt.base.model.reflection.views.SequenceTreeWalkerNode;
import ro.amiq.edt.base.model.reflection.views.SequenceTreeWalkerNodeType;

public class EUVMSequenceTreeUtils {
    public static List<SequenceTreeWalkerNode> getSequenceNodesFromLayer(RfDefElement layer, Set<String> knownTcms, int maxModuleIndex, ParserPath moduleParserPath) {
        try {
            if (layer == null) {
                return Collections.emptyList();
            }
            ArrayList<SequenceTreeWalkerNode> sequenceNodes = new ArrayList<SequenceTreeWalkerNode>();
            IRfFileDef fileDef = layer.getDefFile();
            if (!(fileDef instanceof RfModule)) {
                return Collections.emptyList();
            }
            RfModule module = (RfModule)fileDef;
            RfProject rfProject = layer.getRfProject();
            if (rfProject == null) {
                return Collections.emptyList();
            }
            EModuleInfo moduleInfo = rfProject.getModuleInfo(module.getModuleReference());
            if (moduleInfo == null) {
                return Collections.emptyList();
            }
            AST moduleAST = moduleInfo.getModuleAST();
            if (moduleAST == null) {
                return Collections.emptyList();
            }
            AST layerAST = EUVMSequenceTreeUtils.getLayerAST(moduleAST, layer);
            if (layerAST == null) {
                return Collections.emptyList();
            }
            knownTcms = new HashSet<String>(knownTcms);
            HashSet<String> initialKnownTcms = new HashSet<String>(knownTcms);
            SequenceTreeWalker sequenceTreeWalker = new SequenceTreeWalker(module.getRfProject(), module.getParserPath(), moduleInfo);
            sequenceTreeWalker.setCommentsPreferences(BuildConfigManager.getCommentsPreferences((IProject)rfProject.getProject()));
            sequenceTreeWalker.method_struct_member(layerAST);
            List sequenceElements = sequenceTreeWalker.getSequenceBodyElements();
            if (sequenceElements == null) {
                return Collections.emptyList();
            }
            block7: for (SequenceTreeWalkerNode sequenceElement : sequenceElements) {
                if (sequenceElement == null) continue;
                RfNamedElement element = sequenceElement.getElement();
                switch (sequenceElement.getNodeType()) {
                    case ALL_OF: 
                    case FIRST_OF: {
                        sequenceElement.setChildrenActionBlockLayers(EUVMSequenceTreeUtils.getChildActionLayer(sequenceElement.getActionBlockLayer(), sequenceTreeWalker.getElementsByActionBlock(), maxModuleIndex, moduleParserPath));
                        sequenceNodes.add(sequenceElement);
                        break;
                    }
                    case METHOD_CALL: {
                        List<RfMethodLayer> tcmLayers = EUVMSequenceTreeUtils.getTCMCallLayers(element, sequenceElement.getMethodDeterminant(), maxModuleIndex, moduleParserPath);
                        if (tcmLayers == null) {
                            return sequenceNodes;
                        }
                        for (RfDefElement rfDefElement : tcmLayers) {
                            String tcmFullName = String.valueOf(rfDefElement.getParserPath().path) + " " + rfDefElement.getStartOffset();
                            if (knownTcms.contains(tcmFullName)) continue;
                            knownTcms.add(tcmFullName);
                            List<SequenceTreeWalkerNode> tcmSequenceCalls = EUVMSequenceTreeUtils.getSequenceNodesFromLayer(rfDefElement, knownTcms, maxModuleIndex, moduleParserPath);
                            if (tcmSequenceCalls == null) continue;
                            if (sequenceElement.isInStartBlock()) {
                                sequenceElement.setSequencesFromStart(tcmSequenceCalls);
                                sequenceNodes.add(sequenceElement);
                            } else {
                                sequenceNodes.addAll(tcmSequenceCalls);
                            }
                            knownTcms = initialKnownTcms;
                        }
                        continue block7;
                    }
                    case SEQUENCE: {
                        sequenceNodes.add(sequenceElement);
                    }
                }
            }
            return sequenceNodes;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<RfMethodLayer> getTCMCallLayers(RfNamedElement element, Determinant determinant, int maxModuleIndex, ParserPath moduleParserPath) {
        ArrayList<RfMethodLayer> result = new ArrayList<RfMethodLayer>();
        List tcmLayers = element.getLayers();
        for (RfDefElement layer : tcmLayers) {
            int layerMaxModuleIndex;
            if (!(layer instanceof RfMethodLayer)) continue;
            Determinant layerDeterminant = ((RfMethodLayer)layer).getDeterminant();
            if (determinant != null && (layerDeterminant == null || !determinant.contains(layerDeterminant, true)) || (layerMaxModuleIndex = layer.getMaxModuleIndex()) > maxModuleIndex || !EUVMSequenceTreeUtils.importedBySameTest((RfMethodLayer)layer, moduleParserPath)) continue;
            EUVMSequenceTreeUtils.addLayerOrderedByIsStatements(result, (RfMethodLayer)layer);
        }
        return result;
    }

    private static List<SequenceTreeWalkerNode> getChildActionLayer(RfActionBlockLayer sequenceBlockLayer, Map<RfActionBlockLayer, List<Object>> elementsByActionBlock, int maxModuleIndex, ParserPath moduleParserPath) {
        ArrayList<SequenceTreeWalkerNode> result = new ArrayList<SequenceTreeWalkerNode>();
        if (sequenceBlockLayer == null) {
            return Collections.emptyList();
        }
        List<Object> blockElements = elementsByActionBlock.get(sequenceBlockLayer);
        if (blockElements == null) {
            return Collections.emptyList();
        }
        for (Object blockElement : blockElements) {
            if (blockElement instanceof RfActionBlockLayer) {
                SequenceTreeWalkerNode forkNode = new SequenceTreeWalkerNode(null, ((RfActionBlockLayer)blockElement).getParserPath(), ((RfActionBlockLayer)blockElement).getStartLine(), ((RfActionBlockLayer)blockElement).getEndLine(), ((RfActionBlockLayer)blockElement).getStartOffset(), EUVMSequenceTreeUtils.getActionBlockType((RfActionBlockLayer)blockElement));
                forkNode.setChildrenActionBlockLayers(EUVMSequenceTreeUtils.getChildActionLayer((RfActionBlockLayer)blockElement, elementsByActionBlock, maxModuleIndex, moduleParserPath));
                result.add(forkNode);
                continue;
            }
            if (!(blockElement instanceof SequenceTreeWalkerNode)) continue;
            if (((SequenceTreeWalkerNode)blockElement).getNodeType() == SequenceTreeWalkerNodeType.METHOD_CALL) {
                RfNamedElement element = ((SequenceTreeWalkerNode)blockElement).getElement();
                List tcmLayers = element.getLayers();
                if (tcmLayers == null) continue;
                for (RfDefElement tcmLayer : tcmLayers) {
                    List<SequenceTreeWalkerNode> tcmSequenceCalls = EUVMSequenceTreeUtils.getSequenceNodesFromLayer(tcmLayer, new HashSet<String>(), maxModuleIndex, moduleParserPath);
                    if (tcmSequenceCalls == null) continue;
                    if (((SequenceTreeWalkerNode)blockElement).isInStartBlock()) {
                        ((SequenceTreeWalkerNode)blockElement).setSequencesFromStart(tcmSequenceCalls);
                        result.add((SequenceTreeWalkerNode)blockElement);
                        continue;
                    }
                    result.addAll(tcmSequenceCalls);
                }
                continue;
            }
            result.add((SequenceTreeWalkerNode)blockElement);
        }
        return result;
    }

    private static AST getLayerAST(AST ast, RfDefElement layer) {
        if (ast == null) {
            return null;
        }
        if (EUVMSequenceTreeUtils.isLayer(ast, layer)) {
            return ast;
        }
        AST firstChildAst = EUVMSequenceTreeUtils.getLayerAST(ast.getFirstChild(), layer);
        if (firstChildAst != null) {
            return firstChildAst;
        }
        AST nextLayerAst = EUVMSequenceTreeUtils.getLayerAST(ast.getNextSibling(), layer);
        if (nextLayerAst != null) {
            return nextLayerAst;
        }
        return null;
    }

    private static boolean isLayer(AST ast, RfDefElement layer) {
        RfDefElement astTransientScope = (RfDefElement)SemanticUtils.getTransientScope(RfDefElement.class, (AST)ast);
        return astTransientScope == layer;
    }

    public static List<RfMethodLayer> getSortedTcmLayers(RfStruct struct, Determinant determinant, int maxModuleIndex, ParserPath moduleParserPath, String bodyName) {
        if (struct == null) {
            return Collections.emptyList();
        }
        ArrayList<RfMethodLayer> result = new ArrayList<RfMethodLayer>();
        List structLayers = struct.getLayers();
        block0: for (RfDefElement layer : structLayers) {
            List layerDefElements;
            RfStructLayer structLayer;
            Determinant layerDeterminant;
            if (!(layer instanceof RfStructLayer) || (layerDeterminant = (structLayer = (RfStructLayer)layer).getDeterminant()) == null || determinant == null || !determinant.contains(layerDeterminant, true) || (layerDefElements = layer.getChildren()) == null) continue;
            for (RfDefElement child : layerDefElements) {
                RfMethodLayer methodLayer;
                int layerMaxModuleIndex;
                if (!(child instanceof RfMethodLayer) || (layerMaxModuleIndex = layer.getMaxModuleIndex()) > maxModuleIndex || !bodyName.equals((methodLayer = (RfMethodLayer)child).getName()) || !EUVMSequenceTreeUtils.importedBySameTest(methodLayer, moduleParserPath)) continue;
                EUVMSequenceTreeUtils.addLayerOrderedByIsStatements(result, methodLayer);
                continue block0;
            }
        }
        return result;
    }

    private static void addLayerOrderedByIsStatements(List<RfMethodLayer> layers, RfMethodLayer methodLayer) {
        switch (methodLayer.getLayerKind()) {
            case 377: 
            case 378: {
                layers.clear();
                layers.add(methodLayer);
                break;
            }
            case 376: {
                layers.add(methodLayer);
                break;
            }
            case 375: {
                layers.add(0, methodLayer);
                break;
            }
        }
    }

    public static String computeNodeLabel(Determinant determinant, String nodeName, boolean isInStartSequenceNode) {
        if (determinant == null) {
            return nodeName;
        }
        String label = "";
        String[] determinantArray = determinant.toArray();
        int i = 0;
        while (i < determinantArray.length - 1) {
            label = String.valueOf(label.isEmpty() ? "" : String.valueOf(label) + " ") + determinantArray[i];
            ++i;
        }
        return String.valueOf(isInStartSequenceNode ? "start " : "") + (label.isEmpty() ? "" : String.valueOf(label) + " ") + nodeName;
    }

    public static String getForkNodeString(SequenceTreeWalkerNodeType nodeType) {
        switch (nodeType) {
            case ALL_OF: {
                return "all of";
            }
            case FIRST_OF: {
                return "first of";
            }
            case METHOD_CALL: {
                return "start ";
            }
            case PROCESS: {
                return "branch";
            }
        }
        return "";
    }

    private static SequenceTreeWalkerNodeType getActionBlockType(RfActionBlockLayer actionBlock) {
        switch (actionBlock.getLayerKind()) {
            case 173: {
                return SequenceTreeWalkerNodeType.FIRST_OF;
            }
            case 172: {
                return SequenceTreeWalkerNodeType.ALL_OF;
            }
        }
        return SequenceTreeWalkerNodeType.PROCESS;
    }

    private static boolean importedBySameTest(RfMethodLayer layer, ParserPath moduleParserPath) {
        if (layer == null) {
            return false;
        }
        RfProject rfProject = layer.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ParserPath candidateParserPath = layer.getParserPath();
        if (moduleParserPath == null) {
            Set testFiles = rfProject.getTestFilesForModule(candidateParserPath);
            return testFiles == null || testFiles.isEmpty();
        }
        return rfProject.importedBySameTest(candidateParserPath, moduleParserPath);
    }
}

