/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.uvmsequencetree.IUVMSequenceTreeViewContributor;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewInput;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.model.reflection.views.ESequenceTreeNode;
import ro.amiq.edt.base.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.SequenceTreeWalkerNode;
import ro.amiq.edt.base.model.reflection.views.SequenceTreeWalkerNodeType;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.edt.core.EPluginConfig;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.model.reflection.views.EUVMSequenceTreeUtils;
import ro.amiq.edt.model.reflection.views.EUVMSequenceTreeViewLabelProvider;

public class EUVMSequenceTreeViewContributor
implements IUVMSequenceTreeViewContributor {
    private EUVMSequenceTreeViewLabelProvider labelProvider = new EUVMSequenceTreeViewLabelProvider();
    private boolean hasGUIFilteredMembers;
    private boolean isPrependPackage;
    private List<GUIFilter> expandedXVMFilters;
    private IProject iProject;
    private String bulkDataInfo;

    public LanguageKind getLanguageKind() {
        return LanguageKind.E;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof AbstractRfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        if (!(((AbstractRfTreeElementWrapper)wrapper).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((AbstractRfTreeElementWrapper)wrapper).getRfElement();
    }

    public void gotoElement(final IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
                return;
            }
            final ESequenceTreeNode node = (ESequenceTreeNode)((AbstractRfTreeElementWrapper)wrapper).getRfElement();
            if (node == null) {
                return;
            }
            Action action = new Action(){

                public void run() {
                    EDTFileUtils.getInstance().openFile((AbstractEModelManager)EModelManager.getInstance(), project, node.getParserPath().path, node.getLine(), node.getLabel());
                }
            };
            action.run();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public UVMSequenceTreeViewInput getInput(UVMSequenceTreeViewInputConfigurator inputConfigurator, IRfNamedElementAndScope element) {
        this.hasGUIFilteredMembers = false;
        this.isPrependPackage = inputConfigurator.isPrependPackage();
        IDVTElementWrapper rootSequence = null;
        this.bulkDataInfo = "";
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        UVMSequenceTreeViewInput emptyResult = new UVMSequenceTreeViewInput(this.hasGUIFilteredMembers, Collections.emptyList(), this.bulkDataInfo);
        try {
            IProject project;
            this.hasGUIFilteredMembers = false;
            if (!inputConfigurator.getHistoryItem().getLanguage().equals((Object)LanguageKind.E)) {
                return emptyResult;
            }
            if (!(inputConfigurator.getHistoryItem() instanceof UpdateViewEvent)) {
                return emptyResult;
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfigurator.getHistoryItem();
            if (!(inputConfigurator.getSource() instanceof IProject)) {
                return emptyResult;
            }
            this.iProject = project = (IProject)inputConfigurator.getSource();
            if (!project.isAccessible() || !project.hasNature("ro.amiq.edt.enature")) {
                return emptyResult;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F65")) {
                return emptyResult;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return emptyResult;
            }
            this.updateExpandedXVMFilters(project);
            rootSequence = this.toWrappers(rfProject, ev);
            if (rootSequence == null) {
                return emptyResult;
            }
            this.filterNonTerminalLeafsAndApplyContentFilters(rootSequence);
            rootSequence = this.filterElement(rootSequence, inputConfigurator.getSearchSegments(), inputConfigurator.getSearchStrictness(), inputConfigurator.getUpdateJob());
            elements.add(rootSequence);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new UVMSequenceTreeViewInput(this.hasGUIFilteredMembers, elements, this.bulkDataInfo);
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.labelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.labelProvider.getColumnText(element, 1));
    }

    public IDVTElementWrapper toWrappers(RfProject rfProject, UpdateViewEvent ev) {
        List<RfMethodLayer> allBodyLayers;
        String moduleName;
        if (rfProject == null || ev == null) {
            return null;
        }
        String packageName = ev.getEdtPackageName();
        FullName rootSeqFullName = (FullName)ev.getEdtElementFullName();
        Determinant rootSeqDeterminant = (Determinant)ev.getEdtDeterminant();
        this.bulkDataInfo = "";
        this.bulkDataInfo = rootSeqDeterminant != null ? String.valueOf(this.bulkDataInfo) + rootSeqDeterminant.toString() : String.valueOf(this.bulkDataInfo) + rootSeqFullName.getName();
        ParserPath moduleParserPath = ev.getEdtModuleParserPath();
        if (moduleParserPath != null && !(moduleName = Path.fromOSString((String)moduleParserPath.path).removeFileExtension().lastSegment()).isEmpty()) {
            this.bulkDataInfo = String.valueOf(this.bulkDataInfo) + " [in " + moduleName + "] ";
        }
        int maxModuleIndex = ev.getEdtMaxModuleIndex();
        RfStruct rootSequence = this.getRfStruct(rfProject, packageName, rootSeqFullName);
        if (rootSequence == null && ev.getEdtHasAssociatedType()) {
            rootSequence = (RfStruct)ev.getEdtAssociatedType();
        }
        if (rootSequence == null || !rootSequence.isSequence()) {
            return null;
        }
        AbstractRfTreeElementWrapper rootSequenceWrapper = null;
        RfModule rootSequenceModule = rootSequence.getModule();
        if (rootSequenceModule == null) {
            return rootSequenceWrapper;
        }
        String computedNodeLabel = EUVMSequenceTreeUtils.computeNodeLabel(rootSeqDeterminant, rootSequence.getName(), false);
        ESequenceTreeNode rootSequenceNode = new ESequenceTreeNode(rootSequence, null, computedNodeLabel, rootSequenceModule.getParserPath(), rootSeqDeterminant, SequenceTreeWalkerNodeType.SEQUENCE);
        rootSequenceWrapper = this.makeWrapper(rootSequenceNode);
        RfDefElement rootSequenceDeclaration = rootSequence.getDeclaration();
        if (rootSequenceDeclaration != null) {
            rootSequenceNode.setLine(rootSequenceDeclaration.getStartLine());
            rootSequenceNode.setOffset(rootSequenceDeclaration.getStartOffset());
            rootSequenceNode.setParserPath(rootSequenceDeclaration.getParserPath());
            rootSequenceNode.setMaxModuleIndex(rootSequenceDeclaration.getMaxModuleIndex());
            rootSequenceNode.setCommentBlock(rootSequenceDeclaration.getLayerComment());
        }
        if ((allBodyLayers = this.collectAllBodyLayers(rootSeqDeterminant, maxModuleIndex, moduleParserPath, rootSequence)).isEmpty()) {
            return rootSequenceWrapper;
        }
        RfStructLayer firstBodyLayer = allBodyLayers.get(0).getStructLayer();
        if (firstBodyLayer == null) {
            return rootSequenceWrapper;
        }
        rootSequenceNode.setLine(firstBodyLayer.getStartLine());
        rootSequenceNode.setOffset(firstBodyLayer.getStartOffset());
        rootSequenceNode.setParserPath(firstBodyLayer.getParserPath());
        rootSequenceNode.setMaxModuleIndex(firstBodyLayer.getMaxModuleIndex());
        rootSequenceNode.setCommentBlock(firstBodyLayer.getLayerComment());
        rootSequenceNode.setFirstBodyLayer(firstBodyLayer);
        ArrayList<AbstractRfTreeElementWrapper> rootSequenceChildren = new ArrayList<AbstractRfTreeElementWrapper>();
        for (RfMethodLayer body : allBodyLayers) {
            HashSet<String> knownBodyNames = new HashSet<String>();
            List<SequenceTreeWalkerNode> bodySequenceCalls = EUVMSequenceTreeUtils.getSequenceNodesFromLayer((RfDefElement)body, new HashSet<String>(), maxModuleIndex, moduleParserPath);
            List<AbstractRfTreeElementWrapper> rootSequenceTree = this.makeSequenceTree(rootSequenceNode, bodySequenceCalls, rfProject, packageName, maxModuleIndex, moduleParserPath, knownBodyNames);
            if (rootSequenceTree == null) continue;
            rootSequenceChildren.addAll(rootSequenceTree);
        }
        rootSequenceWrapper.setChildren(rootSequenceChildren);
        return rootSequenceWrapper;
    }

    @NotNull
    private List<RfMethodLayer> collectAllBodyLayers(Determinant rootSeqDeterminant, int maxModuleIndex, ParserPath moduleParserPath, RfStruct rootSequence) {
        List<RfMethodLayer> postBodyLayers;
        List<RfMethodLayer> bodyLayers;
        ArrayList<RfMethodLayer> allBodyLayers = new ArrayList<RfMethodLayer>();
        List<RfMethodLayer> preBodyLayers = EUVMSequenceTreeUtils.getSortedTcmLayers(rootSequence, rootSeqDeterminant, maxModuleIndex, moduleParserPath, "pre_body");
        if (preBodyLayers != null) {
            allBodyLayers.addAll(preBodyLayers);
        }
        if ((bodyLayers = EUVMSequenceTreeUtils.getSortedTcmLayers(rootSequence, rootSeqDeterminant, maxModuleIndex, moduleParserPath, "body")) != null) {
            allBodyLayers.addAll(bodyLayers);
        }
        if ((postBodyLayers = EUVMSequenceTreeUtils.getSortedTcmLayers(rootSequence, rootSeqDeterminant, maxModuleIndex, moduleParserPath, "post_body")) != null) {
            allBodyLayers.addAll(postBodyLayers);
        }
        return allBodyLayers;
    }

    private List<AbstractRfTreeElementWrapper> makeSequenceTree(ESequenceTreeNode parentNode, List<SequenceTreeWalkerNode> bodySequenceCalls, RfProject rfProject, String packageName, int maxModuleIndex, ParserPath moduleParserPath, Set<String> knownBodyNames) {
        if (bodySequenceCalls == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractRfTreeElementWrapper> result = new ArrayList<AbstractRfTreeElementWrapper>();
        HashSet<String> initialKnownBodyNames = new HashSet<String>(knownBodyNames);
        knownBodyNames = new HashSet<String>(knownBodyNames);
        block5: for (SequenceTreeWalkerNode sequenceCall : bodySequenceCalls) {
            RfNamedElement element = sequenceCall.getElement();
            switch (sequenceCall.getNodeType()) {
                case ALL_OF: 
                case FIRST_OF: 
                case PROCESS: {
                    ESequenceTreeNode forkProcessNode = new ESequenceTreeNode(null, null, EUVMSequenceTreeUtils.getForkNodeString(sequenceCall.getNodeType()), sequenceCall.getElementStartLine(), sequenceCall.getElementEndLine(), sequenceCall.getElementOffset(), sequenceCall.getParserPath(), null, sequenceCall.getNodeType());
                    AbstractRfTreeElementWrapper forkNodeWrapper = this.makeWrapper(forkProcessNode);
                    List<AbstractRfTreeElementWrapper> forkChildSequenceTree = this.makeSequenceTree(forkProcessNode, sequenceCall.getChildrenActionBlockLayers(), rfProject, packageName, maxModuleIndex, moduleParserPath, knownBodyNames);
                    forkNodeWrapper.setChildren(forkChildSequenceTree);
                    result.add(forkNodeWrapper);
                    break;
                }
                case METHOD_CALL: {
                    if (sequenceCall.isInStartBlock()) {
                        String elementName = "";
                        if (element != null) {
                            elementName = element.getName();
                        }
                        ESequenceTreeNode methodNode = new ESequenceTreeNode(null, element, String.valueOf(EUVMSequenceTreeUtils.getForkNodeString(sequenceCall.getNodeType())) + elementName + "()@", sequenceCall.getElementStartLine(), sequenceCall.getElementEndLine(), sequenceCall.getElementOffset(), sequenceCall.getParserPath(), null, sequenceCall.getNodeType());
                        AbstractRfTreeElementWrapper methodWrapper = this.makeWrapper(methodNode);
                        List<AbstractRfTreeElementWrapper> startMethodSequenceTree = this.makeSequenceTree(methodNode, sequenceCall.getSequencesFromStart(), rfProject, packageName, maxModuleIndex, moduleParserPath, knownBodyNames);
                        methodWrapper.setChildren(startMethodSequenceTree);
                        result.add(methodWrapper);
                        break;
                    }
                }
                case SEQUENCE: {
                    RfStruct structSequence;
                    RfNamedElement sequenceField = element;
                    if (!(sequenceField instanceof RfField) && !(sequenceField instanceof RfVar)) continue block5;
                    Determinant sequenceDeterminant = null;
                    IRfNamedElement childType = null;
                    if (sequenceField instanceof IRfAssociatedType) {
                        sequenceDeterminant = ((IRfAssociatedType)sequenceField).getAssociatedTypeDeterminant();
                        childType = ((IRfAssociatedType)sequenceField).getAssociatedType();
                    }
                    if (sequenceDeterminant == null || !(childType instanceof RfStruct) || !(structSequence = (RfStruct)childType).isSequence() && !structSequence.isLike("any_sequence_item")) continue block5;
                    ESequenceTreeNode sequenceNode = new ESequenceTreeNode(structSequence, sequenceField, EUVMSequenceTreeUtils.computeNodeLabel(sequenceDeterminant, structSequence.getName(), sequenceCall.isStartSequenceCall()), sequenceCall.getElementStartLine(), sequenceCall.getElementEndLine(), sequenceCall.getElementOffset(), sequenceCall.getParserPath(), sequenceDeterminant, sequenceCall.getNodeType());
                    AbstractRfTreeElementWrapper sequenceWrapper = this.makeWrapper(sequenceNode);
                    ArrayList<AbstractRfTreeElementWrapper> sequenceChildren = new ArrayList<AbstractRfTreeElementWrapper>();
                    List<RfMethodLayer> bodyLayers = this.collectAllBodyLayers(sequenceDeterminant, maxModuleIndex, moduleParserPath, structSequence);
                    sequenceNode.setCommentBlock(sequenceCall.getComment());
                    for (RfMethodLayer body : bodyLayers) {
                        String bodyFullName = String.valueOf(body.getParserPath().path) + " " + body.getStartOffset();
                        if (knownBodyNames.contains(bodyFullName)) continue;
                        knownBodyNames.add(bodyFullName);
                        List<SequenceTreeWalkerNode> childBodySequenceCalls = EUVMSequenceTreeUtils.getSequenceNodesFromLayer((RfDefElement)body, new HashSet<String>(), maxModuleIndex, moduleParserPath);
                        List<AbstractRfTreeElementWrapper> childSequenceTree = this.makeSequenceTree(sequenceNode, childBodySequenceCalls, rfProject, packageName, maxModuleIndex, moduleParserPath, knownBodyNames);
                        if (childSequenceTree == null) continue;
                        sequenceChildren.addAll(childSequenceTree);
                    }
                    sequenceWrapper.setChildren(sequenceChildren);
                    result.add(sequenceWrapper);
                }
                default: {
                    knownBodyNames = new HashSet<String>(initialKnownBodyNames);
                }
            }
        }
        return result;
    }

    protected AbstractRfTreeElementWrapper makeWrapper(ESequenceTreeNode element) {
        RfTreeElementWrapper result = new RfTreeElementWrapper((Object)element);
        result.setProject(this.iProject);
        if (this.isPrependPackage) {
            result.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.PREPEND_TEXT, (Object)"package");
        }
        return result;
    }

    private RfStruct getRfStruct(RfProject project, String packageName, FullName fStructName) {
        block3: {
            try {
                if (project != null && packageName != null && fStructName != null && fStructName.getName() != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return (RfStruct)project.getType(packageName, false, 1, fStructName.getName(), -1);
    }

    private IDVTElementWrapper filterElement(IDVTElementWrapper wrapper, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)wrapper, (DVTBaseLabelProvider)this.labelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
        return wrapper;
    }

    private void updateExpandedXVMFilters(IProject project) {
        this.expandedXVMFilters = DVTPredefinedGUIFilters.getXVMFilter();
        DVTGUIFiltersTopFilePatternExpander.expand(this.expandedXVMFilters, (IProject)project);
    }

    private boolean filterNonTerminalLeafsAndApplyContentFilters(IDVTElementWrapper node) {
        if (!node.hasChildren()) {
            return !this.keep(node);
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            IDVTElementWrapper child = (IDVTElementWrapper)iterator.next();
            if (!this.filterNonTerminalLeafsAndApplyContentFilters(child)) continue;
            iterator.remove();
        }
        if (node.hasChildren()) {
            return false;
        }
        return !this.keep(node);
    }

    private boolean keep(IDVTElementWrapper node) {
        if (node == null) {
            return false;
        }
        Object nodeElement = node.getRfElement();
        if (!(nodeElement instanceof ESequenceTreeNode)) {
            return false;
        }
        switch (((ESequenceTreeNode)nodeElement).getNodeType()) {
            case SEQUENCE: {
                RfStruct sequence = ((ESequenceTreeNode)nodeElement).getSequence();
                if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_SEQUENCE_TREE, (IRfNamedElement)sequence, () -> this.labelProvider.getText(node)) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) break;
                this.hasGUIFilteredMembers = true;
                return false;
            }
            case ALL_OF: 
            case FIRST_OF: 
            case PROCESS: 
            case METHOD_CALL: {
                return false;
            }
        }
        return true;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor) {
        String moduleName;
        RfDefElement defElement;
        IRfScope scopeLayer;
        RfNamedElement namedElement;
        RfNamedElementActionHyperlink hlink;
        IDocument document;
        IProject project;
        IFile file;
        block37: {
            block36: {
                block35: {
                    block34: {
                        List actionLinks;
                        block33: {
                            AbstractEEditor eEditor;
                            block32: {
                                IDocumentProvider documentProvider;
                                IEditorInput editorInput;
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                block27: {
                                                    block26: {
                                                        try {
                                                            if (editor instanceof AbstractEEditor) break block26;
                                                            return null;
                                                        }
                                                        catch (Exception e) {
                                                            DVTLogger.INSTANCE.logError((Throwable)e);
                                                            return null;
                                                        }
                                                    }
                                                    eEditor = (AbstractEEditor)editor;
                                                    editorInput = eEditor.getEditorInput();
                                                    if (editorInput != null) break block27;
                                                    return null;
                                                }
                                                file = (IFile)editorInput.getAdapter(IFile.class);
                                                if (file != null) break block28;
                                                return null;
                                            }
                                            project = file.getProject();
                                            if (project != null) break block29;
                                            return null;
                                        }
                                        RfProject rfProject = RfManager.getInstance().getRfProject(project);
                                        if (rfProject != null) break block30;
                                        return null;
                                    }
                                    documentProvider = eEditor.getDocumentProvider();
                                    if (documentProvider != null) break block31;
                                    return null;
                                }
                                document = documentProvider.getDocument((Object)editorInput);
                                if (document != null) break block32;
                                return null;
                            }
                            actionLinks = RfUtils.getRfNamedElementActionHyperlink((IEPluginConfig)EPluginConfig.getInstance(), (ITextEditor)eEditor, (IProject)project, (IDocument)document, (int)cursor, (boolean)true);
                            if (actionLinks != null && !actionLinks.isEmpty()) break block33;
                            return null;
                        }
                        hlink = this.getElementActionHiperlink(actionLinks);
                        namedElement = hlink.getRfNamedElement();
                        scopeLayer = hlink.getScope();
                        defElement = hlink.getDefElement();
                        if (namedElement != null) break block34;
                        return null;
                    }
                    if (!RfStruct.isPackageElement((Object)namedElement, (boolean)false)) break block35;
                    return null;
                }
                if (!(namedElement instanceof RfCheckThat)) break block36;
                return null;
            }
            if (!(namedElement instanceof RfCoverItem)) break block37;
            return null;
        }
        RfStruct scope = EQuickViewersUtil.getInstance().getEnclosingStruct(hlink.getScope());
        UpdateViewEvent updateEvent = EQuickViewersUtil.getInstance().createViewUpdateEvent((IEPluginConfig)EPluginConfig.getInstance(), (IRfNamedElement)namedElement, project, (IRfScope)scope, true, 5);
        Determinant determinant = null;
        ParserPath moduleParserPath = null;
        int maxModuleIndex = 0;
        if (namedElement.equals(scope) && scopeLayer instanceof RfDefElement) {
            determinant = scopeLayer.getDeterminant();
            moduleParserPath = ((RfDefElement)scopeLayer).getParserPath();
            maxModuleIndex = ((RfDefElement)scopeLayer).getMaxModuleIndex();
            updateEvent.setElementScope((Object)scopeLayer);
        } else if (namedElement instanceof RfStructMember) {
            determinant = ((RfStructMember)namedElement).getAssociatedTypeDeterminant();
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration != null) {
                moduleParserPath = declaration.getParserPath();
                maxModuleIndex = declaration.getMaxModuleIndex();
            }
            if (updateEvent.getEdtHasAssociatedType()) {
                updateEvent.setEdtAssociatedType((Object)((RfStructMember)namedElement).getAssociatedType());
            }
        } else if (namedElement instanceof RfStruct) {
            determinant = ((RfStruct)namedElement).getDeterminant();
            if (defElement == null && scopeLayer instanceof RfDefElement) {
                moduleParserPath = ((RfStructLayer)scopeLayer).getParserPath();
                maxModuleIndex = ((RfStructLayer)scopeLayer).getMaxModuleIndex();
            } else if (defElement instanceof RfStructLayer) {
                determinant = ((RfStructLayer)defElement).getDeterminant();
                moduleParserPath = ((RfStructLayer)defElement).getParserPath();
                maxModuleIndex = ((RfStructLayer)defElement).getMaxModuleIndex();
            }
        }
        updateEvent.setEdtDeterminant((Object)determinant);
        updateEvent.setOffset(document.getLineOfOffset(cursor) + 1);
        updateEvent.setFileName(file.getName());
        updateEvent.setEdtModuleParserPath(moduleParserPath);
        updateEvent.setEdtMaxModuleIndex(maxModuleIndex);
        String text = "";
        text = determinant != null ? determinant.toString() : ((FullName)updateEvent.getEdtElementFullName()).getName();
        if (moduleParserPath != null && !(moduleName = Path.fromOSString((String)moduleParserPath.path).removeFileExtension().lastSegment()).isEmpty()) {
            text = String.valueOf(text) + " [in " + moduleName + "] ";
        }
        if (!text.isEmpty()) {
            updateEvent.setText(text);
        }
        return updateEvent;
    }

    private RfNamedElementActionHyperlink getElementActionHiperlink(List<RfNamedElementActionHyperlink> actionLinks) {
        for (RfNamedElementActionHyperlink link : actionLinks) {
            if (!link.hasSubtypeLabel()) continue;
            return link;
        }
        return actionLinks.get(0);
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.labelProvider;
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        if (!(wrapper.getRfElement() instanceof ESequenceTreeNode)) {
            return null;
        }
        ESequenceTreeNode node = (ESequenceTreeNode)wrapper.getRfElement();
        if (node == null) {
            return null;
        }
        if (node.getFirstBodyLayer() != null) {
            return DVTInspectViewUtils.getInstance().processDefElement(wrapper.getProject(), (IRfDefElement)node.getFirstBodyLayer(), "//", null, 0, null);
        }
        return DVTInspectViewUtils.getInstance().processGoToInfo(wrapper.getProject(), new InspectViewGoToInfo(GoToInfo.of((String)node.getParserPath().path, (int)node.getOffset(), (int)-1, (int)node.getLine(), (int)node.getEndLine(), (String)"", (LanguageKind)LanguageKind.E)), 0);
    }
}

