/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.ESequenceTreeNode;
import ro.amiq.edt.base.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.edt.core.EPluginConfig;

public class EUVMSequenceTreeViewLabelProvider
extends ELabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider((IEPluginConfig)EPluginConfig.getInstance());

    public EUVMSequenceTreeViewLabelProvider() {
        super((IPluginConfig)EPluginConfig.getInstance());
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        String result = this.getColumnText(element, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(String instName, String packName) {
        boolean hasPackName;
        StringBuilder result = new StringBuilder("");
        boolean hasInstName = instName != null && !instName.isEmpty();
        boolean bl = hasPackName = packName != null && !packName.isEmpty();
        if (hasInstName) {
            if (hasPackName) {
                result.append(packName);
                result.append("::");
            }
            result.append(instName);
        }
        return result.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof AbstractRfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        AbstractRfTreeElementWrapper rfWrapper = (AbstractRfTreeElementWrapper)element;
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof ESequenceTreeNode && columnIndex == 0) {
            RfStruct struct = ((ESequenceTreeNode)rfElement).getSequence();
            if (struct == null) {
                switch (((ESequenceTreeNode)rfElement).getNodeType()) {
                    case ALL_OF: 
                    case FIRST_OF: {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FORK_JOIN);
                    }
                    case PROCESS: 
                    case METHOD_CALL: {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FORK_JOIN_PROCESS);
                    }
                }
            } else {
                if (struct.isSequence()) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
                }
                if (struct.isLike("any_sequence_item")) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE_ITEM);
                }
            }
        }
        if (rfElement instanceof ELanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.E_LANGUAGE);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof IDVTElementWrapper)) {
            return "";
        }
        AbstractRfTreeElementWrapper wrapper = (AbstractRfTreeElementWrapper)element;
        Object elem = wrapper.getRfElement();
        if (wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont((IDVTElementWrapper)wrapper);
        }
        if (elem instanceof ELanguageElement && columnIndex == 0) {
            return (String)((ELanguageElement)elem).getInfo();
        }
        if (elem instanceof ESequenceTreeNode) {
            RfStruct struct;
            ESequenceTreeNode seqNode = (ESequenceTreeNode)elem;
            String packName = "";
            if (wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PREPEND_TEXT) == "package" && (struct = ((ESequenceTreeNode)elem).getSequence()) != null) {
                packName = struct.getPackageName();
            }
            String name = seqNode.getLabel();
            if (columnIndex == 0) {
                return this.internalGetText(name, packName);
            }
            return ViewsUtils.trimText((String)(seqNode.getCommentBlock() != null ? seqNode.getCommentBlock() : ""), (int)100, (boolean)true);
        }
        if (elem instanceof String) {
            return "";
        }
        if (elem instanceof RfNamedElement && columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText((Object)wrapper);
        }
        return null;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }
}

