/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.model.reflection.views;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.guifilters.DVTEUVMBrowserGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.LabelProviderInput;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.comparators.CategoryComparator;
import ro.amiq.dvt.ui.views.comparators.LabelProviderWrapperComparator;
import ro.amiq.dvt.ui.views.uvm.hierarchy.IXVMBrowserViewContributor;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewInput;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfDummyElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.AbstractRfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.ELanguageElement;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.edt.base.model.reflection.views.THViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.THViewUtil;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.ui.editor.override.OverrideMethodsUtils;
import ro.amiq.edt.core.EPluginConfig;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.model.reflection.views.EXVMBrowserViewLabelProvider;
import ro.amiq.etools.eparser.ReparseElement;

public class EXVMBrowserViewContributor
implements IXVMBrowserViewContributor {
    private static final String VR_AD_REG = "vr_ad_reg";
    private static final String VR_AD_PKG = "vr_ad";
    private static final String UVM_SCBD_PKG = "uvm_scbd";
    private static final String ANY_SEQUENCE_DRIVER = "any_sequence_driver";
    private static final String ANY_SEQUENCE = "any_sequence";
    private static final String DRIVERS = "Drivers";
    private static final String SEQUENCES = "Sequences";
    private static final String ENVS = "Envs";
    private static final String UVM_ENV = "uvm_env";
    private static final String UVM_SCOREBOARD = "uvm_scoreboard";
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_PKG = "main";
    private static final String VIRTUAL_SEQUENCES = "Virtual Sequences";
    private static final String VIRTUAL_DRIVERS = "Virtual Drivers";
    private static final Map<String, String> UVM_BASE_STRUCTS = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(EXVMBrowserViewContributor.ANY_SEQUENCE, EXVMBrowserViewContributor.SEQUENCES);
            this.put(EXVMBrowserViewContributor.ANY_SEQUENCE_DRIVER, EXVMBrowserViewContributor.DRIVERS);
            this.put("any_sequence_item", "Items");
            this.put("any_port", "Ports");
            this.put("any_env", EXVMBrowserViewContributor.ENVS);
            this.put("uvm_env_config", "Env Configs");
            this.put("uvm_agent", "Agents");
            this.put("uvm_agent_config", "Agent Configs");
            this.put("uvm_bfm", "BFMs");
            this.put("uvm_config_params", "Config Params");
            this.put("uvm_monitor", "Monitors");
            this.put("uvm_collector", "Collectors");
            this.put("uvm_signal_map", "Signal Maps");
            this.put(EXVMBrowserViewContributor.UVM_SCOREBOARD, "Scoreboards");
            this.put(EXVMBrowserViewContributor.VR_AD_REG, "Registers");
            this.put("vr_ad_reg_file", "Register Files");
            this.put("vr_ad_map", "Register Maps");
            this.put("vr_ad_mem", "Memories");
        }
    };
    private static final Map<String, String> UVM_BASE_PACKAGES = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(EXVMBrowserViewContributor.ANY_SEQUENCE, EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put(EXVMBrowserViewContributor.ANY_SEQUENCE_DRIVER, EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("any_sequence_item", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("any_port", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("any_env", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_env_config", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_agent", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_agent_config", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_bfm", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_config_params", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_monitor", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_collector", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put("uvm_signal_map", EXVMBrowserViewContributor.DEFAULT_PKG);
            this.put(EXVMBrowserViewContributor.UVM_SCOREBOARD, EXVMBrowserViewContributor.UVM_SCBD_PKG);
            this.put(EXVMBrowserViewContributor.VR_AD_REG, EXVMBrowserViewContributor.VR_AD_PKG);
            this.put("vr_ad_reg_file", EXVMBrowserViewContributor.VR_AD_PKG);
            this.put("vr_ad_map", EXVMBrowserViewContributor.VR_AD_PKG);
            this.put("vr_ad_mem", EXVMBrowserViewContributor.VR_AD_PKG);
        }
    };
    private static final String TESTFLOW_PKG = "testflow";
    private static final Map<String, String> TESTFLOW_TYPES = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("tf_phase_t", "Phases");
            this.put("tf_domain_t", "Phase domains");
        }
    };
    private static final Set<String> UVM_ACCEL = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("uvm_accel_input_pipe_proxy");
            this.add("uvm_accel_output_pipe_proxy");
        }
    };
    private static final Set<String> LOAD_AND_START_TEST = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("init");
            this.add("pre_generate");
            this.add("post_generate");
            this.add("connect_pointers");
            this.add("connect_ports");
            this.add("check_generation");
            this.add("elaborate");
            this.add("run");
            this.add("quit");
            this.add("extract");
            this.add("check");
            this.add("finalize");
            this.add("do_pack");
            this.add("do_unpack");
        }
    };
    private static final Set<String> SCOREBOARD_SUFFIXES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("_predict");
            this.add("_reconstruct");
        }
    };
    private static final Set<String> SCOREBOARD_PORT_MACRO_NAMES = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("scbd_declare_add_port");
            this.add("scbd_declare_add_port_for_extend");
            this.add("scbd_declare_add_port_group");
            this.add("scbd_declare_match_port");
            this.add("scbd_declare_match_port_for_extend");
            this.add("scbd_declare_match_port_group");
            this.add("scbd_declare_port_group");
        }
    };
    private static final Set<String> SCOREBOARD_METHODS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("set_port_name");
            this.add("add_to_scbd");
            this.add("match_in_scbd");
            this.add("test_match_in_scbd");
            this.add("delete_cached_match");
            this.add("is_matching");
            this.add("match_found");
            this.add("compute_key");
            this.add("format_error_message");
        }
    };
    private static final Set<String> SEQUENCE_METHODS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("body");
            this.add("pre_body");
            this.add("post_body");
        }
    };
    private THViewLabelProvider fMembersLabelProvider = new THViewLabelProvider((IEPluginConfig)EPluginConfig.getInstance(), true);
    private EXVMBrowserViewLabelProvider fComponentsLabelProvider = new EXVMBrowserViewLabelProvider();
    private boolean fHasGUIFilteredMembers;
    private boolean fHasGUIFilteredTree;
    private boolean fHasSearchedElementFiltered;
    private boolean fHasSearchedMemberFiltered;
    private Set<String> scoreboardPorts = new HashSet<String>();
    private Set<RfStruct> virtualSequences = new HashSet<RfStruct>();
    private List<GUIFilter> UVMMembersModeGUIFilter;
    private Map<RfStruct, IDVTElementWrapper> fPackageWrappers = new HashMap<RfStruct, IDVTElementWrapper>();
    boolean fXvmBrowserViewGroupByPackage;
    boolean fXvmBrowserViewPrependPackage;

    public LanguageKind getLanguageKind() {
        return LanguageKind.E;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof AbstractRfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        IRfBaseElement rfElement = this.getRfElement(wrapper);
        if (rfElement == null) {
            return EMPTY_STRING;
        }
        String comment = rfElement instanceof RfNamedElement ? ((RfNamedElement)rfElement).getComment() : ((RfDefElement)rfElement).getLayerComment();
        return comment.replace("\\R", " ");
    }

    private IRfBaseElement getRfElement(Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return null;
        }
        Object rfElement = ((AbstractRfTreeElementWrapper)wrapper).getRfElement();
        if (rfElement instanceof RfNamedElement || rfElement instanceof RfDefElement) {
            return (IRfBaseElement)rfElement;
        }
        return null;
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof AbstractRfTreeElementWrapper)) {
            return;
        }
        Object element = ((AbstractRfTreeElementWrapper)wrapper).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDefElement) {
            actionHyperlink = RfUtils.createOpenAction((IEPluginConfig)EPluginConfig.getInstance(), (RfDefElement)((RfDefElement)element), (IProject)project, null, (boolean)false);
        }
        if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((IEPluginConfig)EPluginConfig.getInstance(), (RfNamedElement)((RfNamedElement)element), (IProject)project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public XVMBrowserViewInput getInput(XVMBrowserViewInputConfigurator inputConfig) {
        List<Object> componentElements = new ArrayList();
        List<Object> memberElements = new ArrayList();
        try {
            IProject project = inputConfig.getProject();
            this.fHasGUIFilteredMembers = false;
            this.fHasGUIFilteredTree = false;
            this.fHasSearchedElementFiltered = false;
            this.fHasSearchedMemberFiltered = false;
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.edt.enature")) {
                return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F65")) {
                return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
            IDVTElementWrapper treeElement = inputConfig.getElement();
            if (treeElement != null) {
                Object treeRfElement = treeElement.getRfElement();
                if (treeRfElement instanceof RfStruct) {
                    RfStruct struct = (RfStruct)treeRfElement;
                    memberElements = this.getSortedMembers(rfProject, inputConfig.getMembersStringMatcher(), struct, struct.getDeterminant(), inputConfig.getUpdateJob());
                }
                if (treeRfElement instanceof RfStructLayer) {
                    RfStructLayer rfStructLayer = (RfStructLayer)treeElement.getRfElement();
                    memberElements = this.getSortedMembers(rfProject, inputConfig.getMembersStringMatcher(), rfStructLayer.getStruct(), rfStructLayer.getDeterminant(), inputConfig.getUpdateJob());
                }
            }
            if (!inputConfig.getUpdateOnlyMembers()) {
                this.updateUVMMembersGUIFilter(project);
                this.computeVirtualSequences(rfProject);
                componentElements = this.getComponentsData(rfProject, inputConfig.getComponentsStringMatcher(), inputConfig.getUpdateJob());
            }
            RfTreeElementWrapper tmpRoot = new RfTreeElementWrapper();
            tmpRoot.addChildren(componentElements);
            if (inputConfig.isShowLanguageNameAsRootElement()) {
                String langInfo = LanguageKind.E.VIEW_NAME;
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper((Object)new ELanguageElement((Object)langInfo));
                languageWrapper.addChildren(tmpRoot.getChildren());
                return new XVMBrowserViewInput(Arrays.asList(languageWrapper), memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
    }

    private void updateUVMMembersGUIFilter(IProject project) {
        this.UVMMembersModeGUIFilter = Arrays.asList(DVTPredefinedGUIFilters.getPredefinedUVMBrowserMembersModeFilter());
        DVTGUIFiltersTopFilePatternExpander.expand(this.UVMMembersModeGUIFilter, (IProject)project);
    }

    private RfStruct getStruct(UpdateViewEvent event, FullName fullName) {
        IProject project = Utils.getProject((String)event.getProjectName());
        if (project == null || !project.isAccessible()) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        String packageName = event.getEdtPackageName();
        if (fullName == null) {
            return null;
        }
        return (RfStruct)rfProject.getType(packageName, false, 1, fullName.getName(), -1);
    }

    private List<IDVTElementWrapper> getComponentsData(RfProject rfProject, StringMatcher componentsStringMatcher, UpdateJob updateJob) {
        List<Object> result = new ArrayList();
        this.fPackageWrappers.clear();
        this.fXvmBrowserViewGroupByPackage = PrefConst.getUVMBrowserViewGroupByPackage();
        this.fXvmBrowserViewPrependPackage = PrefConst.getUVMBrowserViewPrependPackage();
        HashSet<IRfBaseElement> visited = new HashSet<IRfBaseElement>();
        for (String baseComponent : UVM_BASE_STRUCTS.keySet()) {
            List baseStructs = rfProject.getStructsWithPrefix(1, baseComponent);
            if (baseStructs == null || baseStructs.isEmpty()) continue;
            for (RfStruct struct : baseStructs) {
                if (struct == null || !UVM_BASE_PACKAGES.get(baseComponent).equals(struct.getPackageName())) continue;
                this.buildTrees(visited, (IRfBaseElement)struct, componentsStringMatcher, updateJob, null, rfProject);
            }
        }
        this.addExtendedTestflowTypes(rfProject);
        result = this.fPackageWrappers.keySet().size() == 1 && this.fPackageWrappers.keySet().iterator().next() == null ? this.fPackageWrappers.get(null).getChildren() : new ArrayList<IDVTElementWrapper>(this.fPackageWrappers.values());
        RfTreeElementWrapper tmp = new RfTreeElementWrapper((Object)EMPTY_STRING);
        tmp.addChildren(result);
        this.sortAndFilter((IDVTElementWrapper)tmp, componentsStringMatcher, false);
        return tmp.getChildren() == null ? new ArrayList() : tmp.getChildren();
    }

    private boolean sortAndFilter(IDVTElementWrapper w, StringMatcher matcher, boolean matched) {
        if (matcher != null) {
            boolean iMatch = ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fComponentsLabelProvider.getText(w));
            if (iMatch) {
                w.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH, (Object)"*");
            }
            matched = matched || iMatch;
        } else {
            matched = true;
        }
        if (w.getChildren() == null || w.getChildren().isEmpty()) {
            return matched;
        }
        boolean oneChildMatched = false;
        Iterator iterator = w.getChildren().iterator();
        while (iterator.hasNext()) {
            IDVTElementWrapper c = (IDVTElementWrapper)iterator.next();
            boolean childMatched = this.sortAndFilter(c, matcher, matched);
            boolean bl = oneChildMatched = oneChildMatched || childMatched;
            if (childMatched) continue;
            iterator.remove();
        }
        Collections.sort(w.getChildren(), new HierarchyWrappersLexicalSorter());
        return oneChildMatched;
    }

    private String getName(IRfBaseElement e) {
        if (e instanceof IRfDefElement) {
            return ((IRfDefElement)e).getName();
        }
        if (e instanceof IRfNamedElement) {
            return ((IRfNamedElement)e).getName();
        }
        return null;
    }

    private String getPackageName(IRfBaseElement e) {
        if (e instanceof RfStructLayer) {
            return ((RfStructLayer)e).getPackageName();
        }
        if (e instanceof RfStruct) {
            return ((RfStruct)e).getPackageName();
        }
        return null;
    }

    private Map<PkgCat, AbstractRfTreeElementWrapper> buildTrees(Set<IRfBaseElement> visited, IRfBaseElement struct, StringMatcher componentsStringMatcher, UpdateJob updateJob, String category, RfProject rfProject) {
        RfStruct elementStruct;
        boolean isVirtualCategory = false;
        boolean isUVMCategory = UVM_BASE_STRUCTS.containsKey(this.getName(struct));
        if (isUVMCategory) {
            category = UVM_BASE_STRUCTS.get(this.getName(struct));
        }
        if (SEQUENCES.equals(category) && !ANY_SEQUENCE.equals(this.getName(struct))) {
            elementStruct = null;
            if (struct instanceof RfStruct) {
                elementStruct = (RfStruct)struct;
            }
            if (struct instanceof RfStructLayer) {
                elementStruct = ((RfStructLayer)struct).getStruct();
            }
            if (elementStruct != null && elementStruct.isSequence() && elementStruct.isSequenceVirtual()) {
                category = VIRTUAL_SEQUENCES;
                isVirtualCategory = true;
            }
        }
        if (DRIVERS.equals(category) && !ANY_SEQUENCE_DRIVER.equals(this.getName(struct))) {
            elementStruct = null;
            if (struct instanceof RfStruct) {
                elementStruct = (RfStruct)struct;
            }
            if (struct instanceof RfStructLayer) {
                elementStruct = ((RfStructLayer)struct).getStruct();
            }
            if (elementStruct != null && this.isDriverVirtual(elementStruct)) {
                category = VIRTUAL_DRIVERS;
                isVirtualCategory = true;
            }
        }
        boolean isCategory = struct instanceof RfStruct && isUVMCategory;
        String packageName = this.getPackageName(struct);
        RfStruct myPkg = rfProject.getPackage(packageName);
        if (myPkg == null) {
            myPkg = EXVMBrowserViewLabelProvider.DEFAULT_PKG;
        }
        String prependPkgText = myPkg == null ? EMPTY_STRING : String.valueOf(myPkg.getPackageName()) + "::";
        RfStruct pkgGroup = null;
        if (this.fXvmBrowserViewGroupByPackage) {
            pkgGroup = myPkg;
        }
        HashMap<PkgCat, AbstractRfTreeElementWrapper> result = new HashMap<PkgCat, AbstractRfTreeElementWrapper>();
        boolean circularInheritance = visited.contains(struct);
        Collection<IRfBaseElement> children = this.getLikeOrWhenChildren(struct);
        if (children == null || children.isEmpty() || circularInheritance) {
            if (isCategory) {
                return null;
            }
            if (struct instanceof RfStruct && ((RfStruct)struct).isPredefined()) {
                return null;
            }
            RfTreeElementWrapper rfTreeElementWrapper = new RfTreeElementWrapper((Object)struct);
            if (this.fXvmBrowserViewPrependPackage) {
                rfTreeElementWrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.PREPEND_TEXT, (Object)prependPkgText);
            }
            if (struct instanceof IRfDefElement && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_BROWSER_CLASSES, (IRfDefElement)((IRfDefElement)struct), () -> this.lambda$0((AbstractRfTreeElementWrapper)rfTreeElementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!this.fHasSearchedElementFiltered && ViewsUtils.matchCamelCaseOrRegex((StringMatcher)componentsStringMatcher, (String)this.fComponentsLabelProvider.getText(rfTreeElementWrapper))) {
                    this.fHasSearchedElementFiltered = true;
                }
                this.fHasGUIFilteredTree = true;
                return null;
            }
            if (struct instanceof IRfNamedElement && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_BROWSER_CLASSES, (IRfNamedElement)((IRfNamedElement)struct), () -> this.lambda$1((AbstractRfTreeElementWrapper)rfTreeElementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!this.fHasSearchedElementFiltered && ViewsUtils.matchCamelCaseOrRegex((StringMatcher)componentsStringMatcher, (String)this.fComponentsLabelProvider.getText(rfTreeElementWrapper))) {
                    this.fHasSearchedElementFiltered = true;
                }
                this.fHasGUIFilteredTree = true;
                return null;
            }
            if (category == null) {
                return null;
            }
            if (struct instanceof RfStruct && UVM_ENV.equals(this.getName(struct))) {
                return null;
            }
            result.put(new PkgCat(pkgGroup, category), (AbstractRfTreeElementWrapper)rfTreeElementWrapper);
            if (circularInheritance) {
                rfTreeElementWrapper.addChild((IDVTElementWrapper)new RfTreeElementWrapper((Object)new RfDummyElement(rfProject, "[...recurrence detected]")));
                return result;
            }
            return result;
        }
        visited.add(struct);
        for (IRfBaseElement iRfBaseElement : children) {
            Map<PkgCat, AbstractRfTreeElementWrapper> childTrees = this.buildTrees(new HashSet<IRfBaseElement>(visited), iRfBaseElement, componentsStringMatcher, updateJob, category, rfProject);
            if (childTrees == null || childTrees.isEmpty()) continue;
            RfTreeElementWrapper differentCategoryRoot = null;
            for (Map.Entry<PkgCat, AbstractRfTreeElementWrapper> entry : childTrees.entrySet()) {
                PkgCat pkgCat = entry.getKey();
                AbstractRfTreeElementWrapper me = (AbstractRfTreeElementWrapper)result.get(pkgCat);
                if (me == null) {
                    if (isCategory) {
                        if (category.equals(pkgCat.cat)) {
                            me = new RfTreeElementWrapper((Object)new RfDummyElement(rfProject, category));
                        } else {
                            differentCategoryRoot = new RfTreeElementWrapper((Object)new RfDummyElement(rfProject, pkgCat.cat));
                        }
                    } else {
                        me = new RfTreeElementWrapper((Object)struct);
                        if (this.fXvmBrowserViewPrependPackage) {
                            me.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.PREPEND_TEXT, (Object)prependPkgText);
                        }
                        if (pkgGroup != pkgCat.pkg) {
                            me.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.OVR_OUTSIDE_PACKAGE, (Object)EMPTY_STRING);
                        }
                    }
                    if (me != null) {
                        result.put(pkgCat, me);
                    } else {
                        result.put(pkgCat, (AbstractRfTreeElementWrapper)differentCategoryRoot);
                    }
                }
                AbstractRfTreeElementWrapper anyEnvChild = null;
                Object rfElement = null;
                if (isCategory) {
                    if (me != null) {
                        if (ENVS.equals(category) && (anyEnvChild = entry.getValue()) != null && (rfElement = anyEnvChild.getRfElement()) instanceof RfNamedElement && UVM_ENV.equals(((RfNamedElement)rfElement).getName())) {
                            me.addChildren(anyEnvChild.getChildren());
                        } else {
                            me.addChild((IDVTElementWrapper)entry.getValue());
                        }
                    }
                    if (me != null || differentCategoryRoot == null) continue;
                    differentCategoryRoot.addChild((IDVTElementWrapper)entry.getValue());
                    continue;
                }
                if (me == null) continue;
                if (isVirtualCategory) {
                    RfTreeElementWrapper categoryRoot = new RfTreeElementWrapper((Object)new RfDummyElement(rfProject, category));
                    categoryRoot.addChild((IDVTElementWrapper)me);
                    me.addChild((IDVTElementWrapper)entry.getValue());
                    continue;
                }
                me.addChild((IDVTElementWrapper)entry.getValue());
            }
            if (!ViewsUtils.isCanceled((IDVTJob)updateJob)) continue;
            return null;
        }
        if (isCategory) {
            for (Map.Entry entry : result.entrySet()) {
                PkgCat pkgCat = (PkgCat)entry.getKey();
                IDVTElementWrapper packWrapper = this.fPackageWrappers.get(pkgCat.pkg);
                if (packWrapper == null) {
                    packWrapper = new RfTreeElementWrapper((Object)pkgCat.pkg);
                    this.fPackageWrappers.put(pkgCat.pkg, packWrapper);
                }
                boolean added = false;
                if (packWrapper.getChildren() != null && !packWrapper.getChildren().isEmpty()) {
                    for (IDVTElementWrapper child : packWrapper.getChildren()) {
                        RfNamedElement rfElement = (RfNamedElement)child.getRfElement();
                        if (!rfElement.getName().equals(((RfNamedElement)((AbstractRfTreeElementWrapper)entry.getValue()).getRfElement()).getName())) continue;
                        child.addChildren(((AbstractRfTreeElementWrapper)entry.getValue()).getChildren());
                        added = true;
                    }
                }
                if (added) continue;
                packWrapper.addChild((IDVTElementWrapper)entry.getValue());
            }
            return null;
        }
        return result;
    }

    private void computeVirtualSequences(RfProject rfProject) {
        List structs = rfProject.getAllStructs();
        for (RfStruct struct : structs) {
            if (struct.isPredefined() || !struct.isSequence() || !struct.isSequenceVirtual()) continue;
            this.virtualSequences.add(struct);
        }
    }

    private boolean isDriverVirtual(RfStruct driverStruct) {
        for (RfStruct virtualSequence : this.virtualSequences) {
            RfStruct virtualDriver = virtualSequence.getSequenceDriver();
            if (virtualDriver == null || !virtualDriver.equals(driverStruct)) continue;
            return true;
        }
        return false;
    }

    private Collection<IRfBaseElement> getLikeOrWhenChildren(IRfBaseElement element) {
        if (!(element instanceof RfStruct)) {
            return Collections.emptyList();
        }
        RfStruct struct = (RfStruct)element;
        HashMap<Determinant, Object> result = new HashMap<Determinant, Object>();
        List children = struct.getChildStructs();
        if (children != null) {
            for (RfStruct child : children) {
                result.put(child.getDeterminant(), child);
            }
        }
        List allLayers = struct.getLayers();
        for (RfDefElement layer : allLayers) {
            RfStructLayer structLayer;
            if (!(layer instanceof RfStructLayer) || (structLayer = (RfStructLayer)layer).getDeterminant().equals((Object)struct.getDeterminant()) || result.get(structLayer.getDeterminant()) != null || structLayer.isImplicit()) continue;
            RfStructLayer firstLayerOutsideMacroAndSequence = null;
            if (this.isElementIntroducedByUVM((RfNamedElement)struct) && (firstLayerOutsideMacroAndSequence = (RfStructLayer)this.getFirstLayerOutsideMacroAndSequence((RfNamedElement)struct, structLayer.getDeterminant())) == null && !VR_AD_REG.equals(struct.getName())) continue;
            if (firstLayerOutsideMacroAndSequence != null) {
                result.put(structLayer.getDeterminant(), firstLayerOutsideMacroAndSequence);
                continue;
            }
            result.put(structLayer.getDeterminant(), structLayer);
        }
        return result.values();
    }

    private RfDefElement getFirstLayerOutsideMacroAndSequence(RfNamedElement element, Determinant determinant) {
        List layers = element.getLayers();
        for (RfDefElement layer : layers) {
            RfStructLayer structLayer;
            RfStructLayer rfStructLayer = structLayer = layer instanceof RfStructLayer ? (RfStructLayer)layer : layer.getStructLayer();
            if (!structLayer.getDeterminant().equals((Object)determinant) || layer.getStartInfo().virtOffset >= 0 || layer.isImplicit()) continue;
            return layer;
        }
        return null;
    }

    private void addExtendedTestflowTypes(RfProject rfProject) {
        HashMap<PkgCat, AbstractRfTreeElementWrapper> result = new HashMap<PkgCat, AbstractRfTreeElementWrapper>();
        for (Map.Entry<String, String> entry : TESTFLOW_TYPES.entrySet()) {
            RfDefElement typeDeclaration;
            List typeLayers;
            String typeName = entry.getKey();
            RfType type = rfProject.getType(TESTFLOW_PKG, true, 2, typeName, -1);
            if (type == null || type.hasNoLayers() || (typeLayers = ((RfScalarType)type).getLayers()) == null || typeLayers.isEmpty() || (typeDeclaration = type.getDeclaration()) == null) continue;
            for (RfDefElement typeLayer : typeLayers) {
                if (typeLayer.equals(typeDeclaration)) continue;
                this.addLayer(rfProject, result, typeDeclaration, typeLayer, entry.getValue());
            }
        }
        if (!result.isEmpty()) {
            for (Map.Entry<String, String> entry : result.entrySet()) {
                PkgCat pkgCat = (PkgCat)((Object)entry.getKey());
                IDVTElementWrapper packWrapper = this.fPackageWrappers.get(pkgCat.pkg);
                if (packWrapper == null) {
                    packWrapper = new RfTreeElementWrapper((Object)pkgCat.pkg);
                    this.fPackageWrappers.put(pkgCat.pkg, packWrapper);
                }
                packWrapper.addChild((IDVTElementWrapper)entry.getValue());
            }
        }
    }

    private void addLayer(RfProject rfProject, Map<PkgCat, AbstractRfTreeElementWrapper> result, RfDefElement typeDeclaration, RfDefElement typeLayer, String category) {
        PkgCat pkgCat;
        AbstractRfTreeElementWrapper me;
        String packageName = typeDeclaration.getPackageName();
        RfStruct myPkg = rfProject.getPackage(packageName);
        if (myPkg == null) {
            myPkg = EXVMBrowserViewLabelProvider.DEFAULT_PKG;
        }
        String prependPkgText = myPkg == null ? EMPTY_STRING : String.valueOf(myPkg.getPackageName()) + "::";
        RfStruct pkgGroup = null;
        if (this.fXvmBrowserViewGroupByPackage) {
            pkgGroup = myPkg;
        }
        if ((me = result.get(pkgCat = new PkgCat(pkgGroup, category))) == null) {
            me = new RfTreeElementWrapper((Object)new RfDummyElement(rfProject, category));
            result.put(pkgCat, me);
        }
        RfTreeElementWrapper child = new RfTreeElementWrapper((Object)typeLayer);
        if (this.fXvmBrowserViewPrependPackage) {
            child.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.PREPEND_TEXT, (Object)prependPkgText);
        }
        me.addChild((IDVTElementWrapper)child);
    }

    private List<IDVTElementWrapper> getSortedMembers(RfProject project, StringMatcher matcher, RfStruct struct, Determinant targetDeterminat, UpdateJob updateJob) {
        List<IDVTElementWrapper> membersWrappers = this.getMembersWrappers(struct, targetDeterminat, matcher, updateJob);
        LinkedList<IDVTElementWrapper> filteredMembers = new LinkedList<IDVTElementWrapper>();
        if (matcher != null) {
            for (IDVTElementWrapper treeElement : membersWrappers) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return new ArrayList<IDVTElementWrapper>();
                }
                String name = EMPTY_STRING;
                if (treeElement.getRfElement() instanceof RfNamedElement) {
                    name = ((RfNamedElement)treeElement.getRfElement()).getName();
                }
                if (name == null || !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name)) continue;
                filteredMembers.add(treeElement);
            }
            membersWrappers = filteredMembers;
        }
        if (PrefConst.getUVMBrowserViewShowUVMMembers() || PrefConst.getUVMBrowserViewSortByCategory()) {
            Collections.sort(membersWrappers, new CategoryComparator().thenComparing((Comparator)new LabelProviderWrapperComparator((ILabelProvider)this.fMembersLabelProvider, true)));
        }
        return membersWrappers;
    }

    private List<IDVTElementWrapper> getMembersWrappers(RfStruct struct, Determinant determinant, StringMatcher matcher, UpdateJob updateJob) {
        try {
            AbstractCollection elements = new LinkedHashSet<RfNamedElement>();
            ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
            if (struct == null || determinant == null) {
                return result;
            }
            String packageName = struct.getPackageName();
            RfProject rfProject = struct.getRfProject();
            if (rfProject == null) {
                return result;
            }
            if (EMPTY_STRING.equals(determinant.getName())) {
                determinant = struct.getDeterminant();
            }
            if (PrefConst.getUVMBrowserViewShowUVMMembers()) {
                List fields = struct.getFields(packageName, determinant, true, 31);
                for (RfField field : fields) {
                    if (!this.isUVMElement((RfNamedElement)field, struct, determinant, rfProject)) continue;
                    elements.add(field);
                }
                List methods = struct.getMethods(packageName, determinant, true, 31);
                for (RfMethod method : methods) {
                    if (method.isPredefined() && method.isEmpty() || !this.isUVMElement((RfNamedElement)method, struct, determinant, rfProject)) continue;
                    elements.add((RfNamedElement)method);
                }
                List events = struct.getEvents(packageName, determinant, true, 31);
                for (RfEvent event : events) {
                    if (!this.isUVMElement((RfNamedElement)event, struct, determinant, rfProject)) continue;
                    elements.add((RfNamedElement)event);
                }
            } else {
                boolean showInherited = PrefConst.getUVMBrowserViewShowAllInherited();
                elements.addAll(struct.getFields(packageName, determinant, showInherited, 31));
                List methods = struct.getMethods(packageName, determinant, showInherited, 31);
                methods = THViewUtil.INSTANCE.filterElementsDeclaredInLikeParent(methods, struct);
                elements.addAll(methods);
                elements.addAll(struct.getEvents(packageName, determinant, showInherited, 31));
                if (!PrefConst.getUVMBrowserViewSortByCategory()) {
                    ArrayList toSort = new ArrayList(elements);
                    Collections.sort(toSort, new LexicalSorter());
                    elements = toSort;
                }
            }
            return this.toWrappers(elements, determinant, matcher, updateJob);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new ArrayList<IDVTElementWrapper>();
        }
    }

    private boolean isElementIntroducedByUVM(RfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        RfProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return false;
        }
        RfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return false;
        }
        Set reparseParserPaths = rfProject.computeFilesInMacroReparseStack((IRfDefElement)declaration);
        DVTGUIFilterMatcher.GUIFilterResult uvmFilterResult = DVTEUVMBrowserGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_BROWSER_MEMBERS, (String)parserPath.path, (Set)reparseParserPaths, this.UVMMembersModeGUIFilter, (IProject)project);
        return uvmFilterResult != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED;
    }

    private List<IDVTElementWrapper> toWrappers(Collection<RfNamedElement> elements, Determinant determinant, StringMatcher matcher, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        boolean uvmBrowserViewShowUVMMembers = PrefConst.getUVMBrowserViewShowUVMMembers();
        boolean uvmBrowserViewShowPredefined = PrefConst.getUVMBrowserViewShowPredefined();
        boolean uvmBrowserViewShowOnlyPublic = PrefConst.getUVMBrowserViewShowOnlyPublic();
        try {
            if (elements != null) {
                for (RfNamedElement namedElement : elements) {
                    RfTreeElementWrapper finalWrapper;
                    DVTGUIFilterMatcher.GUIFilterResult filterResult;
                    RfDefElement firstLayerOutsideMacroAndSequence;
                    if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                        return new ArrayList<IDVTElementWrapper>();
                    }
                    if (!uvmBrowserViewShowUVMMembers && (!uvmBrowserViewShowPredefined && namedElement.isPredefined() && namedElement.hasNoLayers() || uvmBrowserViewShowOnlyPublic && namedElement.isPublic())) continue;
                    RfTreeElementWrapper wrapper = null;
                    if ((namedElement instanceof RfMethod || namedElement instanceof RfEvent) && (firstLayerOutsideMacroAndSequence = this.getFirstLayerOutsideMacroAndSequence(namedElement, determinant)) != null) {
                        wrapper = new RfTreeElementWrapper((Object)firstLayerOutsideMacroAndSequence, true);
                    }
                    if (wrapper == null) {
                        wrapper = new RfTreeElementWrapper((Object)namedElement, true);
                    }
                    if (!PrefConst.getUVMBrowserViewShowUVMMembers() && (filterResult = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_BROWSER_MEMBERS, (IRfNamedElement)namedElement, () -> this.lambda$2((AbstractRfTreeElementWrapper)(finalWrapper = wrapper)))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        if (filterResult == DVTGUIFilterMatcher.GUIFilterResult.PREFERENCE) continue;
                        if (!this.fHasSearchedMemberFiltered && ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fComponentsLabelProvider.getText(finalWrapper))) {
                            this.fHasSearchedMemberFiltered = true;
                        }
                        this.fHasGUIFilteredMembers = true;
                        continue;
                    }
                    if (uvmBrowserViewShowPredefined && namedElement.isPredefined() && namedElement.hasNoLayers()) {
                        wrapper.setGrayIcon(true);
                    }
                    result.add((IDVTElementWrapper)wrapper);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private boolean isUVMElement(RfNamedElement namedElement, RfStruct enclosingStruct, Determinant determinant, RfProject rfProject) {
        if (!this.hasLayerInChildOrSubtype(namedElement, determinant, rfProject)) {
            return false;
        }
        if (namedElement instanceof RfMethod || namedElement instanceof RfEvent) {
            return this.isUVMMethodOrEvent(namedElement, enclosingStruct, rfProject);
        }
        if (namedElement instanceof RfField) {
            return this.isUVMField((RfField)namedElement, enclosingStruct, determinant, rfProject);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isUVMField(RfField field, RfStruct enclosingStruct, Determinant determinant, RfProject rfProject) {
        if (field.isInstance()) {
            return true;
        }
        fieldType = field.getAssociatedType();
        if (fieldType == null) {
            return false;
        }
        if (fieldType instanceof RfListType) {
            fieldType = ((RfListType)fieldType).getAssociatedType();
        }
        if (!(fieldType instanceof RfNamedElement)) {
            return false;
        }
        if (this.isElementIntroducedByUVM((RfNamedElement)fieldType)) {
            return true;
        }
        if (!(fieldType instanceof RfStruct)) {
            return false;
        }
        if (field.isPort()) {
            if (enclosingStruct.isLike("uvm_scoreboard") && (fieldDeclaration = field.getDeclaration(true)) != null && fieldDeclaration.getReparseStack() != null) {
                var11_9 = reparseStack = fieldDeclaration.getReparseStack();
                var10_10 = reparseStack.length;
                var9_11 = 0;
                while (var9_11 < var10_10) {
                    re = var11_9[var9_11];
                    if (EXVMBrowserViewContributor.SCOREBOARD_PORT_MACRO_NAMES.contains(re.getName())) {
                        this.scoreboardPorts.add(field.getName());
                        break;
                    }
                    ++var9_11;
                }
            }
            return true;
        }
        fieldTypeStruct = (RfStruct)fieldType;
        if (!EXVMBrowserViewContributor.UVM_ACCEL.contains(fieldTypeStruct.getName())) ** GOTO lbl34
        return true;
lbl-1000:
        // 1 sources

        {
            if (EXVMBrowserViewContributor.UVM_BASE_STRUCTS.containsKey(fieldTypeStruct.getName())) {
                return true;
            }
            fieldTypeStruct = fieldTypeStruct.getParentStruct();
lbl34:
            // 2 sources

            ** while (fieldTypeStruct != null)
        }
lbl35:
        // 1 sources

        return false;
    }

    private boolean isUVMMethodOrEvent(RfNamedElement element, RfStruct enclosingStruct, RfProject rfProject) {
        if (element == null || element.hasNoLayers()) {
            return false;
        }
        if (this.isElementIntroducedByUVM(element)) {
            return true;
        }
        if (element instanceof RfMethod) {
            String methodName = element.getName();
            if (methodName == null) {
                return false;
            }
            if (LOAD_AND_START_TEST.contains(methodName)) {
                return true;
            }
            if (enclosingStruct.isLike(UVM_SCOREBOARD)) {
                if (SCOREBOARD_METHODS.contains(methodName)) {
                    return true;
                }
                for (String suffix : SCOREBOARD_SUFFIXES) {
                    if (!methodName.endsWith(suffix) || !this.scoreboardPorts.contains(methodName.substring(0, methodName.indexOf(suffix)))) continue;
                    return true;
                }
            }
            if (enclosingStruct.isLike(ANY_SEQUENCE) && SEQUENCE_METHODS.contains(methodName)) {
                return true;
            }
        }
        return false;
    }

    boolean hasLayerInChildOrSubtype(RfNamedElement element, Determinant childDeterminant, RfProject rfProject) {
        List layers = element.getLayers();
        if (layers == null || layers.isEmpty()) {
            return false;
        }
        block0: for (RfDefElement layer : layers) {
            if (!layer.getStructLayer().getDeterminant().equals((Object)childDeterminant) || layer.isImplicit()) continue;
            if (layer.getStartInfo().virtOffset >= 0) {
                ReparseElement[] reparseStack = layer.getReparseStack();
                if (reparseStack == null) continue;
                ReparseElement[] reparseElementArray = reparseStack;
                int n = reparseStack.length;
                int n2 = 0;
                while (n2 < n) {
                    RfMacro macro;
                    ReparseElement reparseElement = reparseElementArray[n2];
                    if ((!(element instanceof RfField) || !((RfField)element).isPort() || !SCOREBOARD_PORT_MACRO_NAMES.contains(reparseElement.getName())) && (macro = rfProject.getMacro(String.valueOf(reparseElement.getName()) + "'" + reparseElement.getKind())) != null && this.isElementIntroducedByUVM((RfNamedElement)macro)) continue block0;
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        try {
            if (!(element instanceof AbstractRfTreeElementWrapper)) {
                return false;
            }
            Object rfElement = ((IDVTElementWrapper)element).getRfElement();
            if (rfElement == null) {
                return false;
            }
            if (!(rfElement instanceof RfStruct || rfElement instanceof RfStructLayer || rfElement instanceof RfScalarTypeLayer)) {
                return false;
            }
            DVTBaseLabelProvider labelProvider = this.getLabelProvider(element);
            if (matcher != null) {
                return ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)labelProvider.getText(element));
            }
            if (referenceData instanceof UpdateViewEvent) {
                UpdateViewEvent event = (UpdateViewEvent)referenceData;
                RfStruct hierarchyStruct = this.getStruct(event, (FullName)event.getEdtElementFullName());
                if (hierarchyStruct == null) {
                    return false;
                }
                return labelProvider.getText(element).equals(labelProvider.getText((Object)new RfTreeElementWrapper((Object)hierarchyStruct)));
            }
            if (referenceData instanceof AbstractRfTreeElementWrapper) {
                return labelProvider.getText(element).equals(labelProvider.getText(referenceData));
            }
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public HistoryItem createHistoryItemForWrapper(IDVTElementWrapper wrapper, IProject project, int updateHistory) {
        Object namedElement;
        block7: {
            block6: {
                if (wrapper instanceof AbstractRfTreeElementWrapper) break block6;
                return null;
            }
            AbstractRfTreeElementWrapper treeElementWrapper = (AbstractRfTreeElementWrapper)wrapper;
            namedElement = treeElementWrapper.getRfElement();
            if (namedElement != null) break block7;
            return null;
        }
        try {
            if (namedElement instanceof RfStruct) {
                RfStruct rfStruct = (RfStruct)namedElement;
                String text = "[" + project.getName() + "] " + (rfStruct.getEnclosingScope() == null ? EMPTY_STRING : String.valueOf(rfStruct.getEnclosingScope().getName()) + " :: ") + rfStruct.getName();
                return EQuickViewersUtil.getInstance().createViewUpdateEvent((IEPluginConfig)EPluginConfig.getInstance(), text, (IRfNamedElement)rfStruct, project, rfStruct.getEnclosingScope(), false, updateHistory);
            }
            if (namedElement instanceof RfStructLayer) {
                RfStructLayer rfStructLayer = (RfStructLayer)namedElement;
                String text = "[" + project.getName() + "] " + (rfStructLayer.getEnclosingScope() == null ? EMPTY_STRING : String.valueOf(rfStructLayer.getEnclosingScope().getName()) + " :: ") + rfStructLayer.getName();
                return EQuickViewersUtil.getInstance().createViewUpdateEvent((IEPluginConfig)EPluginConfig.getInstance(), text, rfStructLayer, project, rfStructLayer.getEnclosingScope(), false, updateHistory);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public void overrideMethod(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        OverrideMethodsUtils.INSTANCE.overrideMethodFromView(hierarchyWrapper, memberWrapper);
    }

    public boolean canShowOverrideMethodMenuEntry(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        return OverrideMethodsUtils.INSTANCE.canShowOverrideInView(hierarchyWrapper, memberWrapper);
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        Object element;
        Object labelWrapper = null;
        if (wrapper instanceof LabelProviderInput) {
            labelWrapper = ((LabelProviderInput)wrapper).getWrapper();
        }
        if (labelWrapper != null && ((element = ((IDVTElementWrapper)labelWrapper).getRfElement()) instanceof RfStruct || element instanceof RfStructLayer || element instanceof RfDummyElement || element instanceof ELanguageElement || element instanceof RfScalarTypeLayer)) {
            return this.fComponentsLabelProvider;
        }
        return this.fMembersLabelProvider;
    }

    private /* synthetic */ String lambda$0(AbstractRfTreeElementWrapper abstractRfTreeElementWrapper) {
        return this.fComponentsLabelProvider.getText(abstractRfTreeElementWrapper);
    }

    private /* synthetic */ String lambda$1(AbstractRfTreeElementWrapper abstractRfTreeElementWrapper) {
        return this.fComponentsLabelProvider.getText(abstractRfTreeElementWrapper);
    }

    private /* synthetic */ String lambda$2(AbstractRfTreeElementWrapper abstractRfTreeElementWrapper) {
        return this.fMembersLabelProvider.getText((Object)abstractRfTreeElementWrapper);
    }

    private static class HierarchyWrappersLexicalSorter
    implements Comparator<IDVTElementWrapper> {
        private HierarchyWrappersLexicalSorter() {
        }

        @Override
        public int compare(IDVTElementWrapper o1, IDVTElementWrapper o2) {
            Object elem1 = o1.getRfElement();
            Object elem2 = o2.getRfElement();
            if (elem1 instanceof RfStructLayer && elem2 instanceof RfStructLayer) {
                String name1 = ((RfStructLayer)elem1).getDeterminant().toString();
                String name2 = ((RfStructLayer)elem2).getDeterminant().toString();
                return name1.compareTo(name2);
            }
            if (elem1 instanceof RfStruct && elem2 instanceof RfStruct) {
                String name1 = ((RfStruct)elem1).getPackageName();
                String name2 = ((RfStruct)elem2).getPackageName();
                return name1.compareTo(name2);
            }
            if (!(elem1 instanceof RfNamedElement) || !(elem2 instanceof RfNamedElement)) {
                return 0;
            }
            String name1 = ((RfNamedElement)elem1).getName();
            String name2 = ((RfNamedElement)elem2).getName();
            return name1.compareTo(name2);
        }
    }

    private static class LexicalSorter
    implements Comparator<RfNamedElement> {
        private LexicalSorter() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        }
    }

    class PkgCat {
        private RfStruct pkg;
        private String cat;

        public PkgCat(RfStruct pkg, String cat) {
            this.pkg = pkg;
            this.cat = cat;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.cat == null ? 0 : this.cat.hashCode());
            result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PkgCat other = (PkgCat)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.cat == null ? other.cat != null : !this.cat.equals(other.cat)) {
                return false;
            }
            return !(this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg));
        }

        private EXVMBrowserViewContributor getOuterType() {
            return EXVMBrowserViewContributor.this;
        }

        public String toString() {
            return this.pkg + "::" + this.cat;
        }
    }
}

