/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARAA
extends OVMComplianceCheck {
    public CheckARAA(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "ARAA";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARAA_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARAA_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARAA_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct agent : this.fOVMProject.fAgents) {
            Determinant determinant = new Determinant(new String[]{"ACTIVE", agent.getName()});
            List activeAgentSubtypes = agent.getSubTypeLayers(determinant);
            block1: for (RfStructLayer activeAgentSubtype : activeAgentSubtypes) {
                for (RfStruct bfm : this.fOVMProject.fBFMs) {
                    List fields = agent.getFields(agent.getPackageName(), activeAgentSubtype.getDeterminant(), false, 31);
                    for (RfField field : fields) {
                        if (!field.isInstance() || !field.getAssociatedTypeName().equals(bfm.getName())) continue;
                        this.addHit((RfNamedElement)field, "'" + activeAgentSubtype.getDeterminant() + "' instantiates '" + bfm.getName() + "' BFM", false);
                        continue block1;
                    }
                }
                this.addHit((RfDefElement)activeAgentSubtype, "No BFM instance found in '" + activeAgentSubtype.getInfo() + "'", true);
            }
        }
    }
}

