/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARAC
extends OVMComplianceCheck {
    public CheckARAC(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "ARAC";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARAC_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARAC_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARAC_Description;
    }

    @Override
    public void performCheckImpl() {
        List<RfStruct> agents = this.fOVMProject.fAgents;
        for (RfStruct agent : agents) {
            RfField field = agent.getField("name");
            if (field == null) {
                this.addHit((RfNamedElement)agent, "No 'name' field in agent '" + agent.getName() + "'", true);
                continue;
            }
            this.addHit((RfNamedElement)field, "Agent '" + agent.getName() + "'", false);
        }
    }
}

