/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARBF
extends OVMComplianceCheck {
    public CheckARBF(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public String getInternalId() {
        return "ARBF";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARBF_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARBF_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARBF_Description;
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fBFMs.isEmpty()) {
            this.addHit((RfNamedElement)null, "No BFMs found", false);
            return;
        }
        for (RfStruct bfm : this.fOVMProject.fBFMs) {
            boolean hit = false;
            for (RfStruct agent : this.fOVMProject.fAgents) {
                Determinant determinant = new Determinant(new String[]{"ACTIVE", agent.getName()});
                List activeAgentSubtypes = agent.getSubTypeLayers(determinant);
                for (RfStructLayer activeAgentSubtype : activeAgentSubtypes) {
                    List fields = agent.getFields(agent.getPackageName(), activeAgentSubtype.getDeterminant(), false, 31);
                    for (RfField field : fields) {
                        if (!field.isInstance() || !field.getAssociatedTypeName().equals(bfm.getName())) continue;
                        this.addHit((RfDefElement)activeAgentSubtype, "'" + bfm.getName() + "' instantiated in '" + activeAgentSubtype.getDeterminant() + "'", false);
                        hit = true;
                    }
                }
            }
            if (hit) continue;
            this.addHit((RfNamedElement)bfm, "'" + bfm.getName() + "' not instantiated in an ACTIVE agent", true);
        }
    }
}

