/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARIN
extends OVMComplianceCheck {
    public CheckARIN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "ARIN";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARIN_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARIN_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARIN_Description;
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fAgents.isEmpty()) {
            this.addHit((RfNamedElement)null, "No agents found", false);
            return;
        }
        for (RfStruct agent : this.fOVMProject.fAgents) {
            boolean hit = false;
            ArrayList<RfType> allTypes = this.fOVMProject.getAllTypes();
            for (RfType type : allTypes) {
                if (!(type instanceof RfStruct)) continue;
                List fields = ((RfStruct)type).getFields();
                for (RfStructMember field : fields) {
                    if (!((RfField)field).isInstance() || !field.getAssociatedTypeName().equals(agent.getName())) continue;
                    if (this.fOVMProject.fEnvs.contains(type)) {
                        this.addHit((RfNamedElement)field, "'" + DVTStringUtil.replaceAll((Pattern)DVTStringUtil.E_TYPE_LIST_OF, (CharSequence)field.getAssociatedFullTypeName(), (String)"") + "' instantiated in '" + type.getName() + "'", false);
                    } else {
                        this.addHit((RfNamedElement)field, "'" + DVTStringUtil.replaceAll((Pattern)DVTStringUtil.E_TYPE_LIST_OF, (CharSequence)field.getAssociatedFullTypeName(), (String)"") + "' instantiated in '" + type.getName() + "'", true);
                    }
                    hit = true;
                }
            }
            if (hit) continue;
            this.addHit((RfNamedElement)agent, "'" + agent.getName() + "' not instantiated in an 'env' unit", true);
        }
    }
}

