/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARMP
extends OVMComplianceCheck {
    public CheckARMP(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 1, 10);
    }

    @Override
    public String getInternalId() {
        return "ARMP";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARMP_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARMP_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARMP_Description;
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fMonitors.isEmpty()) {
            this.addHit((RfNamedElement)null, "No monitors found", false);
            return;
        }
        boolean hit = false;
        for (RfStruct monitor : this.fOVMProject.fMonitors) {
            List fields = monitor.getFields();
            for (RfStructMember field : fields) {
                RfStruct struct;
                RfType type;
                if (((RfField)field).getDirection() != 2 && ((RfField)field).isInstance() || !((type = field.getAssociatedType()) instanceof RfStruct) || !(struct = (RfStruct)type).isLike("any_simple_port") && !struct.isLike("any_event_port") && !struct.isLike("any_buffer_port") && !struct.isLike("any_method_port")) continue;
                this.addHit((RfNamedElement)field, null, false);
                hit = true;
            }
            if (hit) continue;
            this.addHit((RfNamedElement)monitor, "Monitor '" + monitor.getName() + "' does not contain any out ports", true);
        }
    }
}

