/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARNM
extends OVMComplianceCheck {
    public CheckARNM(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "ARNM";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARNM_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARNM_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARNM_Description;
    }

    @Override
    public void performCheckImpl() {
        List<RfStruct> envs = this.fOVMProject.fEnvs;
        for (RfStruct env : envs) {
            RfField field = env.getField("name");
            if (field == null) {
                this.addHit((RfNamedElement)env, "No 'name' field in eVC '" + env.getName() + "'", true);
                continue;
            }
            this.addHit((RfNamedElement)field, null, false);
        }
    }
}

