/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class CheckAROB
extends OVMComplianceCheck {
    public CheckAROB(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 2, 10);
    }

    @Override
    public String getInternalId() {
        return "AROB";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.AROB_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.AROB_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.AROB_Description;
    }

    @Override
    public void performCheckImpl() {
        String xvmBFMStructName = XVMModeUtils.getBFMStructName(this.getXVMMode());
        ArrayList<RfType> types = this.fOVMProject.getAllTypes();
        boolean hit = false;
        for (RfType type : types) {
            RfStruct struct;
            if (!(type instanceof RfStruct) || !(struct = (RfStruct)type).isLike(xvmBFMStructName)) continue;
            this.addHit((RfNamedElement)struct, "'" + struct.getName() + "' extends '" + xvmBFMStructName + "'", false);
            hit = true;
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No '" + xvmBFMStructName + "' unit in this package", true);
        }
    }
}

