/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class CheckAROC
extends OVMComplianceCheck {
    public CheckAROC(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 2, 10);
    }

    @Override
    public String getInternalId() {
        return "AROC";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.AROC_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.AROC_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.AROC_Description;
    }

    @Override
    public void performCheckImpl() {
        String xvmCollectorStructName = XVMModeUtils.getCollectorStructName(this.getXVMMode());
        ArrayList<RfType> types = this.fOVMProject.getAllTypes();
        boolean hit = false;
        for (RfType type : types) {
            RfStruct struct;
            if (!(type instanceof RfStruct) || !(struct = (RfStruct)type).isLike(xvmCollectorStructName)) continue;
            this.addHit((RfNamedElement)struct, "'" + struct.getName() + "' extends '" + xvmCollectorStructName + "'", false);
            hit = true;
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No '" + xvmCollectorStructName + "' unit in this package", true);
        }
    }
}

