/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public class CheckAROS
extends OVMComplianceCheck {
    public CheckAROS(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 2, 10);
    }

    @Override
    public String getInternalId() {
        return "AROS";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.AROS_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.AROS_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.AROS_Description;
    }

    @Override
    public void performCheckImpl() {
        String xvmSignalMapStructName = XVMModeUtils.getSignalMapStructName(this.getXVMMode());
        ArrayList<RfType> types = this.fOVMProject.getAllTypes();
        boolean hit = false;
        for (RfType type : types) {
            RfStruct struct;
            if (!(type instanceof RfStruct) || !(struct = (RfStruct)type).isLike(xvmSignalMapStructName)) continue;
            this.addHit((RfNamedElement)struct, "'" + struct.getName() + "' extends '" + xvmSignalMapStructName + "'", false);
            hit = true;
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No '" + xvmSignalMapStructName + "' unit in this package", true);
        }
    }
}

