/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARSA
extends OVMComplianceCheck {
    public CheckARSA(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "ARSA";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARSA_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARSA_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARSA_Description;
    }

    @Override
    public void performCheckImpl() {
        boolean found = false;
        for (RfStruct driver : this.fOVMProject.fSequenceDrivers) {
            if (!driver.isLike("any_sequence_driver") || !this.isBFMSequenceDriver(driver.getName())) continue;
            found = true;
            boolean hit = false;
            for (RfStruct agent : this.fOVMProject.fAgents) {
                Determinant determinant = new Determinant(new String[]{"ACTIVE", agent.getName()});
                List activeAgentSubtypes = agent.getSubTypeLayers(determinant);
                for (RfStructLayer activeAgentSubtype : activeAgentSubtypes) {
                    List fields = agent.getFields(agent.getPackageName(), activeAgentSubtype.getDeterminant(), false, 31);
                    for (RfField field : fields) {
                        if (!field.isInstance() || !field.getAssociatedTypeName().equals(driver.getName())) continue;
                        this.addHit((RfNamedElement)field, "'" + driver.getName() + "' sequence driver instantiated in '" + activeAgentSubtype.getDeterminant() + "'", false);
                        hit = true;
                    }
                }
            }
            if (hit) continue;
            this.addHit((RfNamedElement)driver, "'" + driver.getName() + "' sequence driver not instantiated in an ACTIVE 'agent'", true);
        }
        if (!found) {
            this.addHit((RfNamedElement)null, "No sequence driver found", false);
        }
    }

    private boolean isBFMSequenceDriver(String name) {
        List structs = this.fOVMProject.getRfProject().getAllStructs();
        for (RfStruct struct : structs) {
            if (!struct.isSequence() || struct.isSequenceVirtual() || !struct.getSequenceDriverName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

