/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARSD
extends OVMComplianceCheck {
    public CheckARSD(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "ARSD";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARSD_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARSD_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARSD_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct agent : this.fOVMProject.fAgents) {
            Determinant determinant = new Determinant(new String[]{"ACTIVE", agent.getName()});
            List activeAgentSubtypes = agent.getSubTypeLayers(determinant);
            block1: for (RfStructLayer activeAgentSubtype : activeAgentSubtypes) {
                for (RfStruct driver : this.fOVMProject.fSequenceDrivers) {
                    if (this.virtualSequenceDriver(driver.getName())) continue;
                    List fields = agent.getFields(agent.getPackageName(), activeAgentSubtype.getDeterminant(), false, 31);
                    for (RfField field : fields) {
                        if (!field.isInstance() || !field.getAssociatedTypeName().equals(driver.getName())) continue;
                        this.addHit((RfNamedElement)field, "'" + activeAgentSubtype.getDeterminant() + "' instantiates '" + driver.getName() + "' BFM sequence driver", false);
                        continue block1;
                    }
                }
                this.addHit((RfDefElement)activeAgentSubtype, "No BFM sequence driver instance found in '" + activeAgentSubtype.getInfo() + "'", true);
            }
        }
    }

    private boolean virtualSequenceDriver(String name) {
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            if (!sequence.getSequenceDriverName().equals(name) || !sequence.isSequenceVirtual()) continue;
            return true;
        }
        return false;
    }
}

