/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckARSM
extends OVMComplianceCheck {
    public static final int DEFAULT_SEVERITY = 0;
    public static final int DEFAULT_GRADE = 10;

    public CheckARSM(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.setSeverity(0);
        this.setGrade(10);
        this.fDefaultSeverity = 0;
        this.fDefaultGrade = 10;
    }

    @Override
    public String getInternalId() {
        return "ARSM";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.ARSM_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.ARSM_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.ARSM_Description;
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSignalMaps.isEmpty()) {
            this.addHit((RfNamedElement)null, "No signal maps found", false);
            return;
        }
        for (RfStruct smap : this.fOVMProject.fSignalMaps) {
            boolean hit = false;
            ArrayList<RfType> allTypes = this.fOVMProject.getAllTypes();
            for (RfType type : allTypes) {
                if (!(type instanceof RfStruct)) continue;
                List fields = ((RfStruct)type).getFields();
                for (RfStructMember field : fields) {
                    if (!((RfField)field).isInstance() || !field.getAssociatedTypeName().equals(smap.getName())) continue;
                    if (this.fOVMProject.fEnvs.contains(type) || this.fOVMProject.fAgents.contains(type)) {
                        this.addHit((RfNamedElement)field, "'" + DVTStringUtil.replaceAll((Pattern)DVTStringUtil.E_TYPE_LIST_OF, (CharSequence)field.getAssociatedFullTypeName(), (String)"") + "' instantiated in '" + type.getName() + "'", false);
                    } else {
                        this.addHit((RfNamedElement)field, "'" + DVTStringUtil.replaceAll((Pattern)DVTStringUtil.E_TYPE_LIST_OF, (CharSequence)field.getAssociatedFullTypeName(), (String)"") + "' instantiated in '" + type.getName() + "'", true);
                    }
                    hit = true;
                }
            }
            if (hit) continue;
            this.addHit((RfNamedElement)smap, "'" + smap.getName() + "' not instantiated in an 'env' or 'agent' unit", true);
        }
    }
}

