/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckCHCE
extends OVMComplianceCheck {
    public CheckCHCE(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "CHCE";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.CHCE_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.CHCE_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.CHCE_Description;
    }

    @Override
    public void performCheckImpl() {
        boolean hit = false;
        for (RfType type : this.fOVMProject.getAllTypes()) {
            if (!(type instanceof RfStruct)) continue;
            List expects = ((RfStruct)type).getExpects();
            for (RfStructMember expect : expects) {
                RfExpectLayer layer = (RfExpectLayer)this.getRelevantLayer(expect);
                if (layer == null) continue;
                this.addHit((RfDefElement)layer, layer.getLiteral(), false);
                hit = true;
            }
        }
        for (RfModule module : this.fOVMProject.getAllModules()) {
            List checks = module.getCheckThatActions();
            for (RfCheckThat check : checks) {
                this.addHit((RfNamedElement)check, check.getLiteral(), false);
                hit = true;
            }
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No protocol checks found", true);
        }
    }

    private RfDefElement getRelevantLayer(RfStructMember expect) {
        List layers = expect.getLayers();
        if (layers == null) {
            return null;
        }
        RfDefElement result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                result = layer;
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return layer;
        }
        return result;
    }
}

