/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfCheckThat;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfExpectLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckCHDM
extends OVMComplianceCheck {
    public CheckCHDM(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "CHDM";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.CHDM_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.CHDM_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.CHDM_Description;
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList expects = new NullProtectedList();
        for (RfType type : this.fOVMProject.getAllTypes()) {
            if (!(type instanceof RfStruct)) continue;
            expects.addAll((Collection)((RfStruct)type).getExpects());
        }
        for (RfStructMember expect : expects) {
            RfExpectLayer layer = (RfExpectLayer)this.getRelevantLayer(expect);
            this.addHit((RfDefElement)layer, layer.getLiteral(), ((RfExpect)expect).isDefaultDutError());
        }
        NullProtectedList checks = new NullProtectedList();
        for (RfModule module : this.fOVMProject.getAllModules()) {
            checks.addAll((Collection)module.getCheckThatActions());
        }
        for (RfCheckThat check : checks) {
            this.addHit((RfNamedElement)check, check.getLiteral(), check.isDefaultDutError());
        }
    }

    public RfDefElement getRelevantLayer(RfStructMember expect) {
        List layers = expect.getLayers();
        if (layers == null) {
            return null;
        }
        RfDefElement result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                result = layer;
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return layer;
        }
        return result;
    }
}

