/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckCHEX
extends OVMComplianceCheck {
    public CheckCHEX(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "CHEX";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.CHEX_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.CHEX_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.CHEX_Description;
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList expects = new NullProtectedList();
        for (RfType type : this.fOVMProject.getAllTypes()) {
            if (!(type instanceof RfStruct)) continue;
            expects.addAll((Collection)((RfStruct)type).getExpects());
        }
        for (RfStructMember expect : expects) {
            if (((RfExpect)expect).isAnonymous()) {
                this.addHit((RfNamedElement)expect, "Anonymous expect", true);
                continue;
            }
            this.addHit((RfNamedElement)expect, expect.getName(), false);
        }
    }
}

