/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOVMMessage;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckMSMA
extends OVMComplianceCheck {
    public CheckMSMA(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "MSMA";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.MSMA_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.MSMA_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.MSMA_Description;
    }

    @Override
    public void performCheckImpl() {
        boolean hit = false;
        for (RfModule module : this.fOVMProject.getAllModules()) {
            List messages = module.getMessageActions();
            for (RfOVMMessage message : messages) {
                this.addHit((RfNamedElement)message, message.getLiteral(), false);
                hit = true;
            }
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No message actions found.", true);
        }
    }

    public RfDefElement getRelevantLayer(RfExpect expect) {
        List layers = expect.getLayers();
        if (layers == null) {
            return null;
        }
        RfDefElement result = null;
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() == 378) {
                result = layer;
                continue;
            }
            if (layer.getLayerKind() != 377) continue;
            return layer;
        }
        return result;
    }
}

