/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckMSMT
extends OVMComplianceCheck {
    public CheckMSMT(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "MSMT";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.MSMT_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.MSMT_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.MSMT_Description;
    }

    @Override
    public void performCheckImpl() {
        boolean hit = false;
        String packageName = this.fOVMProject.getPackageName();
        RfType messageTag = this.fOVMProject.getRfProject().getType("main", false, 2, "message_tag", -1);
        List layers = messageTag.getLayers();
        if (layers != null) {
            for (RfDefElement layer : layers) {
                Collection enums;
                if (layer.isPredefined() || !layer.getPackageName().equals(packageName) || (enums = ((RfScalarTypeLayer)layer).getEnums()) == null || enums.isEmpty()) continue;
                this.addHit(layer, null, false);
                hit = true;
            }
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No message tags found.", true);
        }
    }
}

