/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckMSSN
extends OVMComplianceCheck {
    public CheckMSSN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "MSSN";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.MSSN_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.MSSN_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.MSSN_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct agent : this.fOVMProject.fAgents) {
            RfMethod method = agent.getMethod("short_name");
            if (method == null) {
                this.addHit((RfNamedElement)agent, null, true);
                continue;
            }
            List methodLayers = method.getLayers();
            if (methodLayers == null || methodLayers.isEmpty()) {
                this.addHit((RfNamedElement)agent, null, true);
                continue;
            }
            boolean gotIt = false;
            for (RfDefElement methodLayer : methodLayers) {
                RfStruct struct;
                RfStructLayer structLayer;
                if (methodLayer == null || (structLayer = methodLayer.getStructLayer()) == null || (struct = structLayer.getStruct()) == null || !agent.equals(struct)) continue;
                this.addHit((RfNamedElement)method, null, false);
                gotIt = true;
                break;
            }
            if (gotIt) continue;
            this.addHit((RfNamedElement)agent, null, true);
        }
    }
}

