/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKDN
extends OVMComplianceCheck {
    public CheckPKDN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKDN";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKDN_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKDN_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKDN_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllMacros()) {
            if (!this.fOVMProject.isProjectModule(rfNamedElement.getModule())) continue;
            String packageName = this.fOVMProject.getPackageName();
            if (rfNamedElement.getName().startsWith(String.valueOf(packageName) + "_")) {
                this.addHit(rfNamedElement, null, false);
                continue;
            }
            this.addHit(rfNamedElement, "The 'define' name <" + rfNamedElement.getName() + "> does not start with package prefix '" + packageName + "_'.", true);
        }
    }
}

