/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKEE
extends OVMComplianceCheck {
    public CheckPKEE(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKEE";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKEE_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKEE_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKEE_Description;
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        List types = rfProject.getAllTypes(true, false);
        for (RfNamedElement type : types) {
            if (!(type instanceof RfScalarType) || !((RfScalarType)type).isEnumType()) continue;
            RfDefElement declaration = type.getDeclaration(false);
            String packageName = "main";
            if (declaration == null) {
                if (!type.isPredefined()) {
                    declaration = type.getFirstLayer();
                }
            } else {
                packageName = declaration.getPackageName();
            }
            List layers = type.getLayers();
            for (RfDefElement layer : layers) {
                if (!this.fOVMProject.isProjectModule(layer.getLayerModule()) || !layer.isEnumType() || layer.getPackageName().equals(packageName)) continue;
                Collection enums = ((RfScalarTypeLayer)layer).getEnums();
                for (RfEnum elem : enums) {
                    String layerPackageName = layer.getPackageName();
                    if (Character.isUpperCase(elem.getName().charAt(0))) {
                        layerPackageName = layer.getPackageName().toUpperCase();
                    }
                    if (elem.getName().startsWith(String.valueOf(layerPackageName) + "_")) {
                        this.addHit(layer, null, false);
                        continue;
                    }
                    this.addHit(layer, "Enum name '" + elem.getName() + "'  does not start with package prefix '" + layerPackageName + "_'.", true);
                }
            }
        }
    }
}

