/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKEN
extends OVMComplianceCheck {
    public CheckPKEN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKEN";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKEN_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKEN_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKEN_Description;
    }

    @Override
    public void performCheckImpl() {
        String packageName = this.fOVMProject.getPackageName();
        for (RfModule module : this.fOVMProject.getAllModules()) {
            boolean packageExplicit = module.isExplicitPackage();
            if (packageExplicit) {
                boolean packageValid = module.getPackageName().equals(packageName);
                if (packageValid) {
                    this.addHit((RfNamedElement)module, null, false);
                    continue;
                }
                this.addHit((RfNamedElement)module, "Wrong package name '" + module.getPackageName() + "'.", true);
                continue;
            }
            this.addHit((RfNamedElement)module, "Missing package definition.", true);
        }
    }
}

