/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKFN
extends OVMComplianceCheck {
    public CheckPKFN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKFN";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKFN_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKFN_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKFN_Description;
    }

    @Override
    public void performCheckImpl() {
        String packageName = this.fOVMProject.getPackageName();
        NullProtectedList<RfModule> modules = this.fOVMProject.getAllModules();
        for (final RfModule module : modules) {
            RfDefElement dummy = new RfDefElement(null, null, 0, new LineInfo(0, 0, -1), new LineInfo(0, 0, -1), null, null){

                public RfModule getLayerModule() {
                    return module;
                }

                public String getInfo() {
                    return null;
                }
            };
            if (module.getName().startsWith(String.valueOf(packageName) + "_")) {
                this.addHit(dummy, null, false);
                continue;
            }
            this.addHit(dummy, "File name does not start with package prefix '" + packageName + "_'.", true);
        }
    }
}

