/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKGE
extends OVMComplianceCheck {
    public CheckPKGE(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKGE";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKGE_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKGE_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKGE_Description;
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        boolean hit = false;
        RfStruct global = (RfStruct)rfProject.getType("main", false, 1, "global", -1);
        List layers = global.getLayers();
        if (layers != null) {
            NullProtectedList<RfNamedElement> members = null;
            for (RfDefElement layer : layers) {
                if (!this.fOVMProject.isProjectModule(layer.getLayerModule()) || (members = this.getAllMembers(global)) == null || members.isEmpty()) continue;
                this.addHit(layer, "'global' unit extension.", true);
                hit = true;
                break;
            }
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No 'global' unit extension found.", false);
        }
    }

    private NullProtectedList<RfNamedElement> getAllMembers(RfStruct struct) {
        List methods;
        List fields;
        NullProtectedList members = new NullProtectedList();
        List events = struct.getEvents();
        if (events != null) {
            members.addAll((Collection)events);
        }
        if ((fields = struct.getFields()) != null) {
            members.addAll((Collection)fields);
        }
        if ((methods = struct.getMethods()) != null) {
            members.addAll((Collection)methods);
        }
        return members;
    }
}

