/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.Collection;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKGN
extends OVMComplianceCheck {
    public CheckPKGN(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKGN";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKGN_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKGN_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKGN_Description;
    }

    @Override
    public void performCheckImpl() {
        RfStruct sys;
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        String packageName = this.fOVMProject.getPackageName();
        RfStruct global = (RfStruct)rfProject.getType("main", false, 1, "global", -1);
        List layers = global.getLayers();
        if (layers != null) {
            NullProtectedList<RfNamedElement> members = null;
            for (RfDefElement layer : layers) {
                if (!this.fOVMProject.isProjectModule(layer.getLayerModule())) continue;
                members = this.getAllMembers(global);
                break;
            }
            if (members != null) {
                for (RfNamedElement member : members) {
                    layers = member.getLayers();
                    for (RfDefElement layer : layers) {
                        if (!this.fOVMProject.isProjectModule(layer.getLayerModule()) || member.isPredefined()) continue;
                        if (member.getName().startsWith(String.valueOf(packageName) + "_")) {
                            this.addHit(member, null, false);
                            continue;
                        }
                        this.addHit(member, "'global' " + this.getMemberName(member) + " does not start with package prefix '" + packageName + "_'.", true);
                    }
                }
            }
        }
        if ((layers = (sys = (RfStruct)rfProject.getType("main", false, 1, "sys", -1)).getLayers()) != null) {
            NullProtectedList<RfNamedElement> members = null;
            for (RfDefElement layer : layers) {
                if (!this.fOVMProject.isProjectModule(layer.getLayerModule())) continue;
                members = this.getAllMembers(sys);
                break;
            }
            if (members != null) {
                for (RfNamedElement member : members) {
                    layers = member.getLayers();
                    for (RfDefElement layer : layers) {
                        if (!this.fOVMProject.isProjectModule(layer.getLayerModule()) || member.isPredefined()) continue;
                        if (member.getName().startsWith(String.valueOf(packageName) + "_")) {
                            this.addHit(member, null, false);
                            continue;
                        }
                        this.addHit(member, "'sys' " + this.getMemberName(member) + " does not start with package prefix '" + packageName + "_'.", true);
                    }
                }
            }
        }
    }

    private String getMemberName(RfNamedElement member) {
        if (member instanceof RfField) {
            return "field '" + member.getName() + "'";
        }
        if (member instanceof RfEvent) {
            return "event '" + member.getName() + "'";
        }
        if (member instanceof RfMethod) {
            return "method '" + member.getName() + "()'";
        }
        return null;
    }

    private NullProtectedList<RfNamedElement> getAllMembers(RfStruct struct) {
        List methods;
        List fields;
        NullProtectedList members = new NullProtectedList();
        List events = struct.getEvents();
        if (events != null) {
            members.addAll((Collection)events);
        }
        if ((fields = struct.getFields()) != null) {
            members.addAll((Collection)fields);
        }
        if ((methods = struct.getMethods()) != null) {
            members.addAll((Collection)methods);
        }
        return members;
    }
}

