/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.ImportFilePath;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKIM
extends OVMComplianceCheck {
    public CheckPKIM(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKIM";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKIM_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKIM_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKIM_Description;
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfModule> modules = this.fOVMProject.getAllModules();
        for (final RfModule module : modules) {
            List importedFiles;
            if (!this.fOVMProject.isProjectModule(module) || (importedFiles = module.getImportedFilePaths()) == null) continue;
            IEProject eProject = EModelManager.getInstance().getEModel().getEProject(this.getIProject());
            if (eProject == null) {
                return;
            }
            CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(true);
            if (!compilationUnitProperties.hasFilesToCompile()) {
                return;
            }
            String rawSpecmanPath = compilationUnitProperties.getSpecmanPath();
            IPath modulePath = Path.fromOSString((String)module.getParserPath().path);
            for (ImportFilePath importedFile : importedFiles) {
                IPath candidatePath;
                IPath filePath = importedFile.getFilePath();
                LineInfo line = new LineInfo(importedFile.getLineNumber(), 0, -1);
                RfDefElement dummy = new RfDefElement(null, null, 0, line, line, null, null){

                    public RfModule getLayerModule() {
                        return module;
                    }

                    public String getInfo() {
                        return null;
                    }
                };
                if (filePath.isAbsolute()) {
                    this.addHit(dummy, "Absolute path not allowed.", true);
                    continue;
                }
                if (filePath.getFileExtension() == null) {
                    filePath = filePath.addFileExtension("e");
                }
                if ((candidatePath = modulePath.removeLastSegments(1).append(filePath)).toFile().exists()) {
                    this.addHit(dummy, null, false);
                    continue;
                }
                if (rawSpecmanPath == null || rawSpecmanPath.length() == 0) continue;
                String[] specmanPath = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)rawSpecmanPath);
                String fileSeparator = System.getProperty("file.separator");
                boolean hit = false;
                int i = 0;
                while (i < specmanPath.length) {
                    String fullFileName = String.valueOf(specmanPath[i]) + fileSeparator + filePath.toOSString();
                    File classicFile = new File(fullFileName);
                    if (classicFile.exists()) {
                        this.addHit(dummy, null, false);
                        hit = true;
                        break;
                    }
                    ++i;
                }
                if (hit) continue;
                this.addHit(dummy, "File not found (check SPECMAN_PATH settings).", true);
            }
        }
    }
}

