/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKPR
extends OVMComplianceCheck {
    public CheckPKPR(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKPR";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKPR_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKPR_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKPR_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfType type : this.fOVMProject.getAllTypes()) {
            if (type.isPublic()) {
                this.addHit((RfNamedElement)type, null, false);
                continue;
            }
            this.addHit((RfNamedElement)type, "'" + type.getName() + "' has " + this.accessModifierToString((RfNamedElement)type) + " access.", true);
        }
    }

    private String accessModifierToString(RfNamedElement type) {
        if (type.isPackage()) {
            return "package";
        }
        if (type.isProtected()) {
            return "protected";
        }
        if (type.isPrivate()) {
            return "private";
        }
        return "public";
    }
}

