/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.util.NullProtectedList;
import ro.amiq.edt.model.EModelManager;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckPKTP
extends OVMComplianceCheck {
    public CheckPKTP(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "PKTP";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.PKTP_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.PKTP_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.PKTP_Description;
    }

    @Override
    public void performCheckImpl() {
        String packageName = this.fOVMProject.getPackageName();
        IEProject eProject = EModelManager.getInstance().getEModel().getEProject(this.getIProject());
        if (eProject == null) {
            return;
        }
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(true);
        if (!compilationUnitProperties.hasFilesToCompile()) {
            return;
        }
        List topFiles = compilationUnitProperties.topFiles();
        NullProtectedList<RfModule> modules = this.fOVMProject.getAllModules();
        for (RfModule module : modules) {
            if (!this.containsPath(topFiles, module.getParserPath())) continue;
            if (module.getName().startsWith(String.valueOf(packageName) + "_")) {
                this.addHit((RfNamedElement)module, null, false);
                continue;
            }
            this.addHit((RfNamedElement)module, "Top module name does not start with package prefix '" + packageName + "_'.", true);
        }
    }

    private boolean containsPath(List<ParserPath> paths, ParserPath parserPath) {
        return paths.contains(parserPath);
    }
}

