/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQBS
extends OVMComplianceCheck {
    public CheckSQBS(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQBS";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.SQBS_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQBS_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQBS_Description;
    }

    @Override
    public void performCheckImpl() {
        boolean hit = false;
        List<RfStruct> sequences = this.fOVMProject.fSequences;
        for (RfStruct sequence : sequences) {
            if (sequence.isSequenceVirtual() || sequence.getSequenceDriverName() == null) continue;
            this.addHit((RfNamedElement)sequence, null, false);
            hit = true;
        }
        if (!hit) {
            this.addHit((RfNamedElement)null, "No BFM sequence drivers found.", true);
        }
    }
}

