/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQPT
extends OVMComplianceCheck {
    public CheckSQPT(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQPT";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.SQPT_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQPT_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQPT_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            if (!sequence.isSequence()) {
                this.addHit((RfNamedElement)sequence, "'" + sequence.getName() + "' is not a sequence.", true);
                continue;
            }
            RfScalarType sequenceKindType = sequence.getSequenceKind();
            if (sequenceKindType == null) {
                this.addHit((RfNamedElement)sequence, "'" + sequence.getSequenceKindName() + "' sequence kind not found.", true);
                continue;
            }
            List enums = sequenceKindType.getEnumsWithPrefix(2, "");
            if (enums == null || enums.isEmpty()) {
                this.addHit((RfNamedElement)sequence, "'" + sequence.getSequenceKindName() + "' sequence kind not an enumerated type.", true);
                continue;
            }
            ArrayList<String> sequenceKinds = new ArrayList<String>();
            for (RfEnum elem : enums) {
                if (elem.getName().equals("MAIN") || elem.getName().equals("RANDOM") || !sequence.isSequenceVirtual() && elem.getName().equals("SIMPLE")) continue;
                sequenceKinds.add(elem.getName());
            }
            if (sequenceKinds.isEmpty()) {
                this.addHit((RfNamedElement)sequence, "No predefined kinds found for sequence '" + sequence.getName() + "'", true);
                continue;
            }
            this.addHit((RfNamedElement)sequence, sequenceKinds.toString(), false);
        }
    }
}

