/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQRWa
extends OVMComplianceCheck {
    public CheckSQRWa(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQRWa";
    }

    @Override
    public String getUserId(boolean isCustom) {
        if (isCustom) {
            return OVMComplianceMessages.SQRWa_User_Id;
        }
        return OVMComplianceMessages.SQRW_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQRWa_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQRWa_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct driver : this.fOVMProject.fSequenceDrivers) {
            List readMethods = driver.getMethodsWithPrefix(driver.getPackageName(), null, 1, "read", 31);
            if (readMethods == null || readMethods.isEmpty()) {
                this.addHit((RfNamedElement)driver, "read() method not extended.", true);
                continue;
            }
            RfMethod readMethod = null;
            RfDefElement readLayer = null;
            if (!readMethods.isEmpty()) {
                readMethod = (RfMethod)readMethods.get(0);
                readLayer = this.methodExtended(readMethod);
            }
            if (readLayer == null) {
                this.addHit((RfNamedElement)driver, "read() method not extended.", true);
                continue;
            }
            this.addHit((RfNamedElement)readMethod, "read() method extended.", false);
        }
    }

    private RfDefElement methodExtended(RfMethod method) {
        List layers = method.getLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() != 376 && layer.getLayerKind() != 377 && layer.getLayerKind() != 375 && layer.getLayerKind() != 378) continue;
            return layer;
        }
        return null;
    }
}

