/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQRWb
extends OVMComplianceCheck {
    public CheckSQRWb(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQRWb";
    }

    @Override
    public String getUserId(boolean isCustom) {
        if (isCustom) {
            return OVMComplianceMessages.SQRWb_User_Id;
        }
        return OVMComplianceMessages.SQRW_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQRWb_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQRWb_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct driver : this.fOVMProject.fSequenceDrivers) {
            List writeMethods = driver.getMethodsWithPrefix(driver.getPackageName(), null, 1, "write", 31);
            if (writeMethods == null || writeMethods.isEmpty()) {
                this.addHit((RfNamedElement)driver, "write() method not extended.", true);
                continue;
            }
            RfMethod writeMethod = null;
            RfDefElement writeLayer = null;
            if (!writeMethods.isEmpty()) {
                writeMethod = (RfMethod)writeMethods.get(0);
                writeLayer = this.methodExtended(writeMethod);
            }
            if (writeLayer == null) {
                this.addHit((RfNamedElement)driver, "write() method not extended.", true);
                continue;
            }
            this.addHit((RfNamedElement)writeMethod, "write() method extended.", false);
        }
    }

    private RfDefElement methodExtended(RfMethod method) {
        List layers = method.getLayers();
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        for (RfDefElement layer : layers) {
            if (layer.getLayerKind() != 376 && layer.getLayerKind() != 377 && layer.getLayerKind() != 375 && layer.getLayerKind() != 378) continue;
            return layer;
        }
        return null;
    }
}

