/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQSD
extends OVMComplianceCheck {
    public CheckSQSD(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQSD";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.SQSD_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQSD_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQSD_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            if (!sequence.isSequenceVirtual()) continue;
            RfMethod readMethod = sequence.getMethod("get_sub_drivers");
            if (readMethod == null) {
                this.addHit((RfNamedElement)sequence, "get_sub_drivers() method not provided.", true);
                continue;
            }
            this.addHit((RfNamedElement)readMethod, null, false);
        }
    }
}

