/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.List;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQVP
extends OVMComplianceCheck {
    public CheckSQVP(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQVP";
    }

    @Override
    public String getUserId(boolean isCustom) {
        return OVMComplianceMessages.SQVP_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQVP_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQVP_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            if (!sequence.isSequenceVirtual()) continue;
            RfStruct driver = sequence.getSequenceDriver();
            List fields = driver.getFields();
            boolean hit = false;
            for (RfStructMember field : fields) {
                RfType type = field.getAssociatedType();
                if (!(type instanceof RfStruct) || !((RfStruct)type).isLike("any_sequence_driver")) continue;
                this.addHit((RfNamedElement)field, "'" + type.getName() + "' is sub-driver of '" + driver.getName() + "'.", false);
                hit = true;
            }
            if (hit) continue;
            this.addHit((RfNamedElement)driver, "Virtual sequence driver '" + driver.getName() + " has no pointer leading to other sequence driver.", true);
        }
    }
}

