/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQWRa
extends OVMComplianceCheck {
    public CheckSQWRa(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQWRa";
    }

    @Override
    public String getUserId(boolean isCustom) {
        if (isCustom) {
            return OVMComplianceMessages.SQWRa_User_Id;
        }
        return OVMComplianceMessages.SQWR_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQWRa_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQWRa_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            RfMethod readMethod = sequence.getMethod("read");
            if (readMethod == null) {
                this.addHit((RfNamedElement)sequence, "read() method not provided.", true);
                continue;
            }
            this.addHit((RfNamedElement)readMethod, null, false);
        }
    }
}

