/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceMessages;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class CheckSQWRb
extends OVMComplianceCheck {
    public CheckSQWRb(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category, 0, 10);
    }

    @Override
    public String getInternalId() {
        return "SQWRb";
    }

    @Override
    public String getUserId(boolean isCustom) {
        if (isCustom) {
            return OVMComplianceMessages.SQWRb_User_Id;
        }
        return OVMComplianceMessages.SQWR_User_Id;
    }

    @Override
    public String getDefaultTitle() {
        return OVMComplianceMessages.SQWRb_Title;
    }

    @Override
    public String getDefaultDescription() {
        return OVMComplianceMessages.SQWRb_Description;
    }

    @Override
    public void performCheckImpl() {
        for (RfStruct sequence : this.fOVMProject.fSequences) {
            RfMethod writeMethod = sequence.getMethod("write");
            if (writeMethod == null) {
                this.addHit((RfNamedElement)sequence, "write() method not provided.", true);
                continue;
            }
            this.addHit((RfNamedElement)writeMethod, null, false);
        }
    }
}

