/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.model.reflection.RfManager;
import ro.amiq.edt.ovmcompliance.OVMProject;

public class OVMComplianceBuilder {
    private static volatile OVMComplianceBuilder fInstance;
    private static final Object fSyncInstance;
    private HashMap<IProject, OVMProject> fOVMProjects;
    private HashMap<IProject, OVMProject> fUVMProjects;
    private SaveJob fSaveJob = new SaveJob();

    static {
        fSyncInstance = new Object();
    }

    HashMap<IProject, OVMProject> getXVMProjects(int aXVMMode) {
        return aXVMMode == 1 ? this.fOVMProjects : this.fUVMProjects;
    }

    public OVMComplianceBuilder() {
        this.fOVMProjects = new HashMap();
        this.fUVMProjects = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OVMComplianceBuilder getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new OVMComplianceBuilder();
            }
        }
        return fInstance;
    }

    public boolean createOVMProjectIfNotAlready(IProject project, int aXVMMode) {
        if (project == null) {
            return false;
        }
        OVMProject ovmProject = this.getXVMProjects(aXVMMode).get(project);
        if (ovmProject == null) {
            ovmProject = new OVMProject(project, aXVMMode);
            this.getXVMProjects(aXVMMode).put(project, ovmProject);
            return true;
        }
        return false;
    }

    public OVMProject initializeOVMProject(IProject project, int aXVMMode) {
        if (project == null) {
            return null;
        }
        OVMProject ovmProject = this.getXVMProjects(aXVMMode).get(project);
        if (ovmProject == null) {
            ovmProject = new OVMProject(project, aXVMMode);
            this.getXVMProjects(aXVMMode).put(project, ovmProject);
        }
        ovmProject.initialize(aXVMMode);
        return ovmProject;
    }

    public OVMProject populateOVMProjectByName(IProject project) {
        RfProject fProject = RfManager.getInstance().getRfProject(project);
        if (fProject == null) {
            return null;
        }
        OVMProject ovmProject = this.getXVMProjects(1).get(project);
        if (ovmProject == null) {
            return null;
        }
        ovmProject.populateByName();
        return ovmProject;
    }

    public void build(OVMProject project) {
        if (project == null) {
            return;
        }
        project.build();
    }

    public boolean checkErrors(OVMProject project) {
        if (project == null) {
            return true;
        }
        return project.fCheckErrors;
    }

    public void save(OVMProject project, long delay) {
        this.fSaveJob.cancel();
        this.fSaveJob.setProject(project);
        this.fSaveJob.schedule(delay);
    }

    class SaveJob
    extends Job {
        private OVMProject fOVMProject;

        public SaveJob() {
            super("Save Compliance Preferences");
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == OVMComplianceBuilder.this;
        }

        protected void setProject(OVMProject project) {
            this.fOVMProject = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.fOVMProject == null) {
                return Status.OK_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.fOVMProject.save();
            return Status.OK_STATUS;
        }
    }
}

