/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckHit;
import ro.amiq.edt.ovmcompliance.IOVMComplianceManualCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceStatistic;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.OVMComplianceStatistic;

public class OVMComplianceCategory
implements IOVMComplianceCategory {
    private String fName;
    private String fDescription;
    private ArrayList<IOVMComplianceCheck> fChecks;
    private ArrayList<IOVMComplianceStatistic> fStatistics;
    public static final String ARCHITECTURE_COMPLIANCE = "Architecture";
    public static final String RESET_COMPLIANCE = "Reset and Clock";
    public static final String CHECKING_COMPLIANCE = "Checking";
    public static final String COVERAGE_COMPLIANCE = "Coverage";
    public static final String SEQUENCES_COMPLIANCE = "Sequences";
    public static final String MESSAGING_COMPLIANCE = "Messaging";
    public static final String DOCUMENTATION_COMPLIANCE = "Documentation";
    public static final String GENERAL_DELIVERABLES_COMPLIANCE = "General Deliverables";
    public static final String END_OF_TEST_COMPLIANCE = "End of Test";
    public static final String PACKAGE_COMPLIANCE = "Package";

    public OVMComplianceCategory(String name, String description) {
        this.fName = name;
        this.fDescription = description;
        this.fChecks = new ArrayList();
        this.fStatistics = new ArrayList();
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    protected void addCheck(OVMComplianceCheck check) {
        this.fChecks.add(check);
    }

    protected void addStatistic(OVMComplianceStatistic statistic) {
        this.fStatistics.add(statistic);
    }

    protected void removeStatistic(OVMComplianceStatistic statistic) {
        this.fStatistics.remove(statistic);
    }

    protected int getGrade() {
        int grade = 0;
        for (IOVMComplianceCheck check : this.fChecks) {
            grade += ((OVMComplianceCheck)check).getGrade();
        }
        return grade / this.fChecks.size();
    }

    public boolean hasChecks() {
        return this.fChecks != null && !this.fChecks.isEmpty();
    }

    public boolean hasStatistics() {
        return this.fStatistics != null && !this.fStatistics.isEmpty();
    }

    @Override
    public ArrayList<IOVMComplianceCheck> getChecks() {
        return this.fChecks;
    }

    @Override
    public ArrayList<IOVMComplianceStatistic> getStatistics() {
        return this.fStatistics;
    }

    @Override
    public int getNofChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        return this.fChecks.size();
    }

    @Override
    public int getNofStatistics() {
        return this.fStatistics.size();
    }

    @Override
    public int getNofEnabledChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        int enabled = 0;
        for (IOVMComplianceCheck check : this.fChecks) {
            if (!check.isEnabled()) continue;
            ++enabled;
        }
        return enabled;
    }

    @Override
    public int getNofEnabledStatistics() {
        int enabled = 0;
        for (IOVMComplianceStatistic statistic : this.fStatistics) {
            if (!statistic.isEnabled()) continue;
            ++enabled;
        }
        return enabled;
    }

    @Override
    public int getNofFailedChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        int failed = 0;
        block0: for (IOVMComplianceCheck check : this.fChecks) {
            for (IOVMComplianceCheckHit hit : check.getHits()) {
                if (!hit.isFailure()) continue;
                ++failed;
                continue block0;
            }
        }
        return failed;
    }

    @Override
    public int getNofFailedManualChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        int failed = 0;
        for (IOVMComplianceCheck check : this.fChecks) {
            if (!check.isEnabled() || !(check instanceof IOVMComplianceManualCheck) || ((IOVMComplianceManualCheck)check).getStatus() != 2) continue;
            ++failed;
        }
        return failed;
    }

    @Override
    public int getNofNotAppliedManualChecks() {
        if (this.fChecks == null) {
            return 0;
        }
        int notApplied = 0;
        for (IOVMComplianceCheck check : this.fChecks) {
            if (!check.isEnabled() || !(check instanceof IOVMComplianceManualCheck) || ((IOVMComplianceManualCheck)check).getStatus() != 0) continue;
            ++notApplied;
        }
        return notApplied;
    }
}

