/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheck;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckHit;
import ro.amiq.edt.ovmcompliance.OVMComplianceBuilder;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.OVMComplianceCheckHit;
import ro.amiq.edt.ovmcompliance.OVMComplianceManager;
import ro.amiq.edt.ovmcompliance.OVMProject;

public abstract class OVMComplianceCheck
extends OVMComplianceCheckBase
implements IOVMComplianceCheck {
    public static final String ERROR_ENCODING = "ERROR";
    public static final String WARNING_ENCODING = "WARNING";
    public static final String NOTE_ENCODING = "NOTE";
    public static final int DEFAULT_SEVERITY = 1;
    public static final int DEFAULT_GRADE = 10;
    private int fSeverity;
    private int fGrade;
    protected int fDefaultSeverity;
    protected int fDefaultGrade;
    private ArrayList<IOVMComplianceCheckHit> fCheckHits;

    public OVMComplianceCheck(OVMProject oVMProject, OVMComplianceCategory category) {
        this(oVMProject, category, 1, 10);
    }

    public OVMComplianceCheck(OVMProject oVMProject, OVMComplianceCategory category, int severity, int grade) {
        super(oVMProject, category);
        this.fDefaultSeverity = severity;
        this.fSeverity = severity;
        this.fDefaultGrade = grade;
        this.fGrade = grade;
        this.fCheckHits = new ArrayList();
        category.addCheck(this);
    }

    @Override
    public int getSeverity() {
        return this.fSeverity;
    }

    public void setSeverity(int severity) {
        this.fSeverity = severity;
    }

    @Override
    public void setSeverityAndSave(int severity) {
        this.fSeverity = severity;
        OVMComplianceBuilder.getInstance().save(this.fOVMProject, 0L);
    }

    public int getGrade() {
        return this.fGrade;
    }

    public void setGrade(int grade) {
        this.fGrade = grade;
    }

    public void setGradeAndSave(int grade) {
        this.fGrade = grade;
        OVMComplianceBuilder.getInstance().save(this.fOVMProject, 0L);
    }

    public String encodePreference() {
        switch (this.fSeverity) {
            case 0: {
                return ERROR_ENCODING;
            }
            case 1: {
                return WARNING_ENCODING;
            }
        }
        return NOTE_ENCODING;
    }

    @Override
    public void restoreDefaults() {
        super.restoreDefaults();
        this.fSeverity = this.fDefaultSeverity;
        this.fGrade = this.fDefaultGrade;
        OVMComplianceBuilder.getInstance().save(this.fOVMProject, 0L);
    }

    protected void setDefaultPriority(int defaultPriority) {
        this.fDefaultGrade = defaultPriority;
    }

    protected void setDefaultSeverity(int defaultSeverity) {
        this.fDefaultSeverity = defaultSeverity;
    }

    public void loadToProgramDefault() {
        super.loadProgramDefault();
        this.setSeverity(1);
        this.fDefaultSeverity = 1;
        this.setGrade(10);
        this.fDefaultGrade = 10;
    }

    @Override
    public ArrayList<IOVMComplianceCheckHit> getHits() {
        Collections.sort(this.fCheckHits, new OVMComplianceCheckComparator());
        if (OVMComplianceManager.getInstance().isLimited()) {
            ArrayList<IOVMComplianceCheckHit> result = new ArrayList<IOVMComplianceCheckHit>(1);
            int i = 0;
            while (i < this.fCheckHits.size()) {
                if (i == 0) {
                    result.add(this.fCheckHits.get(0));
                } else {
                    result.add(new OVMComplianceCheckHit("limited version - will show only first hit", null, null, 0, this.fCheckHits.get(i).isFailure(), this.fCheckHits.get(i).getCheck()));
                }
                ++i;
            }
            return result;
        }
        if (OVMComplianceManager.getInstance().isNotLimited()) {
            return this.fCheckHits;
        }
        return null;
    }

    @Override
    public int getNofHits() {
        return this.fCheckHits.size();
    }

    protected void addHit(RfNamedElement elm, String detail, boolean isFailure) {
        if (elm == null) {
            this.addHit("none", 0, detail, null, isFailure);
        } else {
            this.addHit(elm.getModule().getParserPath().path, elm.getLine(), detail, null, isFailure);
        }
    }

    protected void addHit(RfDefElement elm, String detail, boolean isFailure) {
        if (elm == null) {
            this.addHit("none", 0, detail, null, isFailure);
        } else {
            this.addHit(elm.getLayerModule().getParserPath().path, elm.getStartLine(), detail, null, isFailure);
        }
    }

    private void addHit(String file, int line, String detail, Deque<String> macroStack, boolean isFailure) {
        StringBuilder macroInfo = new StringBuilder();
        if (macroStack != null && !macroStack.isEmpty()) {
            Iterator<String> it = macroStack.descendingIterator();
            while (it.hasNext()) {
                macroInfo.append("\n    ").append(it.next().trim());
            }
        }
        this.addHitNoDuplicates(new OVMComplianceCheckHit(file, detail, macroInfo.toString(), line, isFailure, this));
    }

    private void addHitNoDuplicates(OVMComplianceCheckHit newHit) {
        this.fCheckHits.add(newHit);
    }

    @Override
    public int getNofPassed() {
        int passed = 0;
        for (IOVMComplianceCheckHit hit : this.fCheckHits) {
            if (hit.isFailure()) continue;
            ++passed;
        }
        return passed;
    }

    @Override
    protected void resetResultInfo() {
        if (this.fCheckHits != null) {
            this.fCheckHits.clear();
        }
    }

    static class OVMComplianceCheckComparator
    implements Comparator<IOVMComplianceCheckHit> {
        OVMComplianceCheckComparator() {
        }

        @Override
        public int compare(IOVMComplianceCheckHit o1, IOVMComplianceCheckHit o2) {
            if (o1.isFailure() && !o2.isFailure()) {
                return -1;
            }
            if (!o1.isFailure() && o2.isFailure()) {
                return 1;
            }
            int stringCompareResult = o1.getFile().compareTo(o2.getFile());
            if (stringCompareResult != 0) {
                return stringCompareResult;
            }
            return o1.getLine() - o2.getLine();
        }
    }
}

