/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.core.Messages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.ovmcompliance.IOVMComplianceCheckBase;
import ro.amiq.edt.ovmcompliance.OVMComplianceBuilder;
import ro.amiq.edt.ovmcompliance.OVMComplianceCategory;
import ro.amiq.edt.ovmcompliance.OVMProject;
import ro.amiq.edt.ovmcompliance.XVMModeUtils;

public abstract class OVMComplianceCheckBase
implements IOVMComplianceCheckBase {
    public static final boolean DEFAULT_ENABLE = true;
    protected OVMProject fOVMProject;
    protected OVMComplianceCategory fCategory;
    protected boolean fEnabled = true;
    protected boolean fDefaultEnabled = true;
    protected ArrayList<OVMComplianceCheckBase> fSubChecks;
    private String fTitle;
    private String fDescription;

    public OVMComplianceCheckBase(OVMProject ovmProject, OVMComplianceCategory category) {
        this.fCategory = category;
        this.fOVMProject = ovmProject;
    }

    public OVMComplianceCheckBase(OVMProject ovmProject, OVMComplianceCategory category, OVMComplianceCheckBase parentCheck) {
        this(ovmProject, category);
        if (parentCheck != null) {
            parentCheck.addSubCheck(this);
            this.fEnabled = parentCheck.fEnabled;
        }
    }

    public abstract String getDefaultDescription();

    public abstract String getDefaultTitle();

    protected abstract void resetResultInfo();

    @Override
    public String getTitle() {
        if (this.fTitle == null) {
            this.fTitle = Messages.bind((String)this.getDefaultTitle(), (Object[])XVMModeUtils.getMessageSubstitutionParameters(this.fOVMProject.getXVMMode()));
        }
        return this.fTitle;
    }

    @Override
    public String getDescription() {
        if (this.fDescription == null) {
            this.fDescription = Messages.bind((String)this.getDefaultDescription(), (Object[])XVMModeUtils.getMessageSubstitutionParameters(this.fOVMProject.getXVMMode()));
        }
        return this.fDescription;
    }

    @Override
    public OVMComplianceCategory getCategory() {
        return this.fCategory;
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public void performCheck() {
        try {
            this.resetResultInfo();
            if (!this.fEnabled) {
                return;
            }
            this.performCheckImpl();
        }
        catch (Exception e) {
            this.notifyCheckError();
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public abstract void performCheckImpl();

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        if (this.fSubChecks == null) {
            return;
        }
        for (OVMComplianceCheckBase subCheck : this.fSubChecks) {
            subCheck.setEnabled(enabled);
            subCheck.performCheck();
        }
    }

    @Override
    public void setEnabledAndSave(boolean enabled) {
        this.setEnabled(enabled);
        OVMComplianceBuilder.getInstance().save(this.fOVMProject, 0L);
    }

    @Override
    public void restoreDefaults() {
        this.setEnabledAndSave(this.fDefaultEnabled);
    }

    protected void setDefaultEnabled(boolean defaultEnabled) {
        this.fDefaultEnabled = defaultEnabled;
        if (this.fSubChecks == null) {
            return;
        }
        for (OVMComplianceCheckBase subCheck : this.fSubChecks) {
            subCheck.setDefaultEnabled(defaultEnabled);
        }
    }

    public void loadProgramDefault() {
        this.fEnabled = true;
        this.fDefaultEnabled = true;
    }

    protected IProject getIProject() {
        return this.fOVMProject.getRfProject().getProject();
    }

    protected void addSubCheck(OVMComplianceCheckBase check) {
        if (this.fSubChecks == null) {
            this.fSubChecks = new ArrayList();
        }
        this.fSubChecks.add(check);
    }

    protected ArrayList<OVMComplianceCheckBase> getSubChecks() {
        return this.fSubChecks;
    }

    protected void clearSubChecks() {
        if (this.fSubChecks != null) {
            this.fSubChecks.clear();
        }
    }

    protected void notifyCheckError() {
        this.fOVMProject.notifyCheckError();
    }

    protected int getXVMMode() {
        return this.fOVMProject.getXVMMode();
    }
}

