/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.ovmcompliance;

import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.ovmcompliance.ui.OVMComplianceReportInput;

public class OVMComplianceManager {
    private static volatile OVMComplianceManager fInstance;
    private static final Object fSyncInstance;
    private boolean fNotLimited;
    private boolean fLimited;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OVMComplianceManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new OVMComplianceManager();
            }
        }
        return fInstance;
    }

    public boolean isLimited() {
        return this.fLimited;
    }

    public boolean isNotLimited() {
        return this.fNotLimited;
    }

    public void setLimited(boolean limited) {
        this.fLimited = limited;
    }

    public void setNotLimited(boolean notLimited) {
        this.fNotLimited = notLimited;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(IResource resource, int aXVMMode) {
        try {
            OVMComplianceReportInput editorInput = new OVMComplianceReportInput(resource.getProject(), aXVMMode);
            try {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)editorInput);
                if (editorPart != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editorPart);
                    this.maximizeEditor((IWorkbenchPart)editorPart);
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {}
            boolean state = true;
            if (!DVTPlugin.getDefault().collect().c(resource.getProject(), "F65")) {
                return false;
            }
            OVMComplianceManager.getInstance().setLimited(!state);
            if (!DVTPlugin.getDefault().collect().c(resource.getProject(), "F65")) {
                return false;
            }
            OVMComplianceManager.getInstance().setNotLimited(state && !OVMComplianceManager.getInstance().isLimited());
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void maximizeEditor(IWorkbenchPart editorPart) {
        try {
            if (editorPart == null) {
                return;
            }
            IWorkbenchPartSite site = editorPart.getSite();
            if (site == null) {
                return;
            }
            IWorkbenchPage page = site.getPage();
            if (page == null) {
                return;
            }
            IWorkbenchPartReference partReference = page.getActivePartReference();
            if (partReference == null) {
                return;
            }
            page.setPartState(partReference, 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

